/**
 * @(#)UserHolder.java, 2020/12/9.
 * <p/>
 * Copyright 2020 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.bean;

import org.springframework.stereotype.Component;

/**
 * B端管理系统用户信息
 *
 * @author: 莫闲
 * @date: 2020-12-09 13:19
 **/
@Component
public class AdminUserHolder {

    // 当前登录用户名线程绑定
    private static ThreadLocal<String> userThreadLocal = new ThreadLocal<>();

    public static void clear() {
        userThreadLocal.remove();
    }

    /**
     * 获取用户名
     *
     * @return 用户名，null-未登录
     */
    public static String getUserName() {
        return userThreadLocal.get();
    }

    public static void setUserName(String userName) {
        userThreadLocal.set(userName);
    }
}
