package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowFile;

/**
 * 子单文件 Mapper
 */
@Mapper
public interface ChangeSubFlowFileMapper extends tk.mybatis.mapper.common.Mapper<ChangeSubFlowFile> {

    /**
     * 根据子单记录ID查询文件列表
     */
    @Select("SELECT * FROM TB_YX_QC_CHANGE_SUB_FLOW_FILE WHERE sub_flow_record_id = #{subFlowRecordId}")
    List<ChangeSubFlowFile> selectBySubFlowRecordId(@Param("subFlowRecordId") Long subFlowRecordId);

    /**
     * 批量插入文件
     */
    @Insert({ "<script>",
            "insert into TB_YX_QC_CHANGE_SUB_FLOW_FILE(sub_flow_record_id, file_type, file_name, file_url, create_time, update_time) values ",
            "<foreach collection='list' item='item' index='index' separator=','>",
            "(#{item.subFlowRecordId}, #{item.fileType}, #{item.fileName}, #{item.fileUrl}, #{item.createTime}, #{item.updateTime})",
            "</foreach>", "</script>" })
    void insertList(List<ChangeSubFlowFile> files);

    /**
     * 根据子单记录ID删除文件
     */
    @Delete("delete from TB_YX_QC_CHANGE_SUB_FLOW_FILE where sub_flow_record_id = #{subFlowRecordId}")
    Integer deleteBySubFlowRecordId(@Param("subFlowRecordId") Long subFlowRecordId);

    /**
     * 根据子单记录ID和文件类型删除文件
     */
    @Delete("delete from TB_YX_QC_CHANGE_SUB_FLOW_FILE where sub_flow_record_id = #{subFlowRecordId} and file_type = #{type}")
    void deleteBySubFlowRecordIdAndType(@Param("subFlowRecordId") Long subFlowRecordId, @Param("type") Integer type);
}

