package com.netease.mail.yanxuan.change.common.bean;

/**
 * @author: bndong
 * @date: 2021/5/25
 */
public class RequestLocalBean {

    /**
     * 存储当前的用户的Id
     */
    private static final ThreadLocal<Long> userIdLocal = new ThreadLocal<>();

    /**
     * 存储当期用户的uid
     */
    private static final ThreadLocal<String> uidLocal = new ThreadLocal<>();

    /**
     * 存储当前请求的ip信息
     */
    private static final ThreadLocal<String> ipLocal = new ThreadLocal<>();

    /**
     * 真实姓名
     */
    private static final ThreadLocal<String> nameLocal = new ThreadLocal<>();

    /**
     * 最近登录时间
     */
    private static final ThreadLocal<Long> lastLoginTimeLocal = new ThreadLocal<>();

    public static void rmrRequestUserId() {
        userIdLocal.remove();
    }

    public static Long getRequestUserId() {
        return userIdLocal.get();
    }

    public static void setRequestUserId(Long userId) {
        userIdLocal.set(userId);
    }

    public static void rmrRequestIp() {
        ipLocal.remove();
    }

    public static String getRequestIp() {
        return ipLocal.get();
    }

    public static void setRequestIp(String ip) {
        ipLocal.set(ip);
    }

    public static void rmUid() {
        uidLocal.remove();
    }

    public static String getUid() {
        return uidLocal.get();
    }


    public static void setUid(String uid) {
        uidLocal.set(uid);
    }

    public static void rmrName() {
        nameLocal.remove();
    }

    public static String getName() {
        return nameLocal.get();
    }

    public static void setName(String name) {
        nameLocal.set(name);
    }

    public static void rmrLastLoginTime() {
        lastLoginTimeLocal.remove();
    }

    public static Long getLastLoginTime() {
        return lastLoginTimeLocal.get();
    }

    public static void setLastLoginTime(Long lastLoginTime) {
        lastLoginTimeLocal.set(lastLoginTime);
    }

    public static void clear() {
        RequestLocalBean.rmUid();
        RequestLocalBean.rmrRequestIp();
        RequestLocalBean.rmrRequestUserId();
        RequestLocalBean.rmrName();
        RequestLocalBean.rmrLastLoginTime();
    }

}
