package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.flow.email.EmailTemplateRpcService;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class EmailTemplateServiceImpl {

    /**
     * 调用链接
     * private static final String TEST_URL = "http://127.0.0.1:8550/proxy/test.yanxuan-template.service.mailsaas/templates/flowx/template/assemble.json";
     * private static final String ONELINE_URL = "http://127.0.0.1:8550/proxy/online.yanxuan-template.service.mailsaas/templates/flowx/template/assemble.json";
     */
    Logger logger = LoggerFactory.getLogger(EmailTemplateServiceImpl.class);

    @Autowired
    private EmailTemplateRpcService service;

    public String template(String templateCode, Object mockData, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("mockData", mockData);
        params.put("templateCode", templateCode);
        params.put("type", type);
        logger.info(JSONObject.toJSONString("邮箱接口参数展示mockData={},templateCode={},type={}"),mockData,templateCode, type);
        AjaxResponse<String> response = service.template(params);
        logger.info("请求后参数展示\n"+response);
        return response.getData();
    }
}
