/**
 * @(#)ChangeExecConfigReq.java, 2022/11/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/15
 */
@Data
public class ChangeExecConfigReq {
    /**
     * 变更行动项记录id
     */
    private Long changeExecId;

    /**
     * 变更类型配置记录id
     */
    //@NotNull(message = "变更记录id不可为空")
    private Long changeTemplateId;

    /**
     * 变更行动部门，（历史字段：变更执行部门名），改
     */
    @NotBlank(message = "变更执行部门名不能为空")
    private String changeExecDepartment;

    /**
     * 变更行动人类型
     */
    private Integer changeExecUserType;

    /**
     * 变更行动人（不同类型存储不同内容）
     */
    private String changeExecUser;

    /**
     * 变更行动人邮箱
     */
    private String changeExecUserEmail;

    /**
     * 变更风险描述
     */
    private String changeRiskDesc;

    /**
     * 行动项
     */
    private String changeExecProject;

    /**
     * 变更验证措施
     */
    private String changeChecking;

    /**
     * 变更完成时间（历史字段：行动完成时间）,改
     */
    private Long changeExecFinishTime;

    /**
     * 行动完成情况
     */
    private String changeExecFinishDesc;
}