package com.netease.mail.yanxuan.change.biz.biz;

import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeExecConfigReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 变更行动项业务逻辑
 * @author system
 */
@Component
@Slf4j
public class ChangeExecRecordBiz {

    /**
     * 根据 ChangeExecConfigReq 列表构建 ChangeExecRecord 列表
     * 
     * @param changeRecordId 变更记录ID
     * @param changeExecProjectList 变更行动方案列表
     * @param subFlowId 子流程工单ID（可选，主单场景传 null）
     * @param subFlowRecordId 变更行动工单记录ID（可选，主单场景传 null）
     * @return 变更行动项列表
     */
    public List<ChangeExecRecord> buildChangeExecRecord(Long changeRecordId,
                                                        List<ChangeExecConfigReq> changeExecProjectList,
                                                        String subFlowId,
                                                        Long subFlowRecordId) {
        return changeExecProjectList.stream().map(c -> {
            ChangeExecRecord changeExecRecord = new ChangeExecRecord();
            changeExecRecord.setChangeRecordId(changeRecordId);
            changeExecRecord.setChangeExecDepartment(c.getChangeExecDepartment());
            changeExecRecord.setChangeExecUserType(c.getChangeExecUserType());
            changeExecRecord.setChangeExecUser(c.getChangeExecUser());
            changeExecRecord.setChangeExecUserEmail(c.getChangeExecUserEmail());
            changeExecRecord.setChangeRiskDesc(c.getChangeRiskDesc());
            changeExecRecord.setChangeExecProject(c.getChangeExecProject());
            changeExecRecord.setChangeChecking(c.getChangeChecking());
            changeExecRecord.setChangeExecFinishTime(c.getChangeExecFinishTime());
            changeExecRecord.setChangeExecFinishDesc(c.getChangeExecFinishDesc());
            changeExecRecord.setSubFlowId(subFlowId);
            changeExecRecord.setSubFlowRecordId(subFlowRecordId);
            changeExecRecord.setCreateTime(DateUtils.getCurrentTime());
            changeExecRecord.setUpdateTime(DateUtils.getCurrentTime());
            return changeExecRecord;
        }).collect(Collectors.toList());
    }

    /**
     * 校验行动项的必填字段
     * 
     * @param changeExecProjectList 行动项列表
     */
    public void validateChangeExecProjectRequiredFields(List<ChangeExecConfigReq> changeExecProjectList) {
        if (CollectionUtils.isEmpty(changeExecProjectList)) {
            return;
        }
        
        changeExecProjectList.forEach(c -> {
            if (StringUtils.isBlank(c.getChangeExecUser())) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动项中变更行动人不能为空");
            }
            if (StringUtils.isBlank(c.getChangeExecUserEmail())) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动项中变更行动人邮箱不能为空");
            }
            if (StringUtils.isBlank(c.getChangeRiskDesc())) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动项中变更风险描述不能为空");
            }
            if (StringUtils.isBlank(c.getChangeExecProject())) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动项中行动项内容不能为空");
            }
            if (c.getChangeExecFinishTime() == null || c.getChangeExecFinishTime() <= 0) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动项中变更完成时间不能为空");
            }
        });
    }
}

