package com.netease.mail.yanxuan.change.biz.biz;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.FlowService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowOperationTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowxOperationEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowCreateReq;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.FlowCreateReqDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Component
@Slf4j
public class ChangeSubFlowBiz {

    @Autowired
    private ChangeSubFlowService changeSubFlowService;

    @Autowired
    private FlowService flowService;


    public String createAndSubmit(@Valid ChangeSubFlowCreateReq changeSubFlowCreateReq) {
        String uid = RequestLocalBean.getUid();
        String name = RequestLocalBean.getName();
        Map<String, Object> content = new HashMap<>(10);
        content.put("createUserName", uid);
        content.put("createUser", uid);
        content.put("createTime", System.currentTimeMillis());
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        String flowName = "";
        // 组装工单创建数据
        FlowCreateReqDTO flowCreateReqDTO = buildFlowCreateReqDTO(ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), uid,
                JSON.toJSONString(content), FlowxOperationEnum.CREATE.getName(), name, flowName);
        // 创建工单
        String subFlowId = flowService.createFlow(flowCreateReqDTO);

        ChangeExecRecord execRecord = new ChangeExecRecord();
        changeSubFlowService.createSubFlow(execRecord);
        return "";
    }

    private FlowCreateReqDTO buildFlowCreateReqDTO(String topoId, String uid, String content, String operateResult,
                                                   String name, String flowName) {
        FlowCreateReqDTO flowCreateReqDTO = new FlowCreateReqDTO();
        flowCreateReqDTO.setTopoId(topoId);
        flowCreateReqDTO.setUid(uid);
        flowCreateReqDTO.setUserName(name);
        flowCreateReqDTO.setOperateResult(operateResult);
        flowCreateReqDTO.setWorkOrderId(StringUtils.joinWith("-", topoId, UUID.randomUUID().toString()));
        flowCreateReqDTO.setContent(content);
        flowCreateReqDTO.setFlowName(flowName);
        return flowCreateReqDTO;
    }

    public List<ChangeExecRecord> list(Integer page, Integer pageSize) {
        return changeSubFlowService.query((page - 1) * pageSize, pageSize);
    }
}
