package com.netease.mail.yanxuan.change.biz.service.impl.change;

import com.netease.mail.yanxuan.change.biz.service.change.ChangeExecConfigService;
import com.netease.mail.yanxuan.change.common.bean.AdminUserHolder;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecConfig;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeExecConfigMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class ChangeExecConfigServiceImpl implements ChangeExecConfigService {

    @Autowired
    private ChangeExecConfigMapper mapper;

    @Override
    public List<ChangeExecConfig> queryChangeExecConfig(Long changeTemplateId) {
        return mapper.queryChangeExecConfig(changeTemplateId);
    }

    @Override
    public List<ChangeExecConfig> addChangeExecConfig(Long id,List<ChangeExecConfig> changeExecConfigs) {
        long currentTime = System.currentTimeMillis();
        //循环添加
        for (ChangeExecConfig changeExecConfig : changeExecConfigs){
            //如果变更行动方案是变更发起人的话就填充登入人信息
            if(changeExecConfig.getChangeExecUserType() == 1){
                changeExecConfig.setChangeExecUser(AdminUserHolder.getUserName());
            }
            //在修改的时候实际上删除在新增需要屏蔽掉ID
            if (changeExecConfig.getId() != null){
                changeExecConfig.setId(null);
            }
            changeExecConfig.setChangeTemplateId(id);
            changeExecConfig.setCreateTime(currentTime);
            changeExecConfig.setUpdateTime(currentTime);
            //行动项,变更风险描述,  变更验证措施, 需要判断字段长度   参数验证 暂不验证
            mapper.insertSelective(changeExecConfig);
        }
        return changeExecConfigs;
    }

    @Override
    public List<ChangeExecConfig> updateChangeExecConfig(Long id,List<ChangeExecConfig> changeExecConfigs) {
        //删除原来的行动
        deleteChangeConfig(id);
        return addChangeExecConfig(id,changeExecConfigs);
    }

    @Override
    public Boolean deleteChangeConfig(Long changeTemplateId) {
        mapper.deleteChangeConfig(changeTemplateId);
        return true;
    }
}
