package com.netease.mail.yanxuan.change.common.constants;

/**
 * 工单流转类型常量
 * 用于 paramMap 中的 type 参数，控制 topo 图的流转方向
 * 
 * @Author AI Assistant
 * @Date 2025/01/04
 */
public class FlowTransitionType {
    
    /**
     * 类型1：审批通过/前进到下一节点/需要审批
     */
    public static final Integer TYPE_APPROVED = 1;
    
    /**
     * 类型2：审批不通过/回退/不需要审批（跳过）
     */
    public static final Integer TYPE_REJECTED = 2;
    
    /**
     * 类型3：回退到确认变更方案节点（主单审批不通过专用）
     */
    public static final Integer TYPE_BACK_TO_CONFIRM_PLAN = 3;
    
    private FlowTransitionType() {
        // 工具类，禁止实例化
    }
}

