package com.netease.mail.yanxuan.change.integration.email.email;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.email.conig.RpcTemplate;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.integration.email.exception.RpcException;
import com.netease.mail.yanxuan.change.integration.email.dto.UserInfoDTO;
import java.io.IOException;

public class IusRpcResult<T> implements RpcTemplate.CallHandler<T> {

    private static final String CODE = "code";

    private static final String RESULT = "data";

    private static final String ERROR_CODE = "errorCode";

    private static final String ERROR_MESSAGE = "errorMsg";

    private Class<T> tClass;

    public IusRpcResult(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public T handle(String resp) throws IOException {
        JSONObject rpcResult = JSON.parseObject(resp);
        ResponseResult responResult = new ResponseResult();
        int code = rpcResult.getIntValue(CODE);
        if (code == ResponseCode.SUCCESS.getCode()) {
            String data = rpcResult.getString(RESULT);
            UserInfoDTO jsonObject = JSON.parseObject(data, UserInfoDTO.class);
            responResult.setData(jsonObject);
            return (T) responResult;
        }
        String errorMessage = rpcResult.getString(ERROR_MESSAGE);
        Integer errorCode = rpcResult.getInteger(ERROR_CODE);
        throw new RpcException("ius response error, resp=" + JSON.toJSONString(resp) + " , errorCode : " + errorCode
            + " , errorMessage : " + errorMessage);
    }
}
