package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.email.conig.RpcTemplate;
import com.netease.mail.yanxuan.change.integration.email.email.EmailTemplateResponResult;
import com.netease.mail.yanxuan.change.integration.email.email.EmailTemplateRpcResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class EmailTemplateServiceImpl {

    private static final String TEST_URL = "http://127.0.0.1:8550/proxy/test.yanxuan-template.service.mailsaas/templates/flowx/template/assemble.json";

    private static final String ONELINE_URL = "http://127.0.0.1:8550/proxy/online.yanxuan-template.service.mailsaas/templates/flowx/template/assemble.json";

    @Value("${rpc.url.email.template}")
    private String url;

    @Autowired
    private RpcTemplate rpcTemplate;

    public String template(String templateCode, Object mockData, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("mockData", mockData);
        params.put("templateCode", templateCode);
        params.put("type", type);
        EmailTemplateResponResult emailTemplateResponResult = rpcTemplate.postJson(url, new JSONObject(params).toJSONString(), 500, new EmailTemplateRpcResult<>(EmailTemplateResponResult.class));
        return emailTemplateResponResult.getData();
    }
}
