/**
 * @(#)ChangeFlowExcelVo.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.excel;

import java.util.ArrayList;
import java.util.List;

import com.netease.mail.dp.des.common.api.enums.ExcelCellType;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.yanxuan.change.common.anno.ExcelTitleName;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Data
public class ChangeFlowExcelVo {
    /**
     * 变更id
     */
    @ExcelTitleName(title = "变更id", order = 1)
    private Long flowId;

    /**
     * 变更发起时间
     */
    @ExcelTitleName(title = "变更发起时间", order = 2)
    private String createTime;

    /**
     * 变更发起人
     */
    @ExcelTitleName(title = "变更发起人", order = 3)
    private String changeCreator;

    /**
     * 变更主体
     * @see ChangeSubjectEnum
     */
    @ExcelTitleName(title = "变更主体", order = 4)
    private String changeSubject;

    /**
     * 变更类型，一级类型>二级类型
     */
    @ExcelTitleName(title = "变更类型", order = 5)
    private String changeType;

    /**
     * 变更等级
     */
    @ExcelTitleName(title = "变更等级", order = 6)
    private String changeLevel;

    /**
     * 变更负责部门名
     */
    @ExcelTitleName(title = "变更负责部门", order = 7)
    private String changeDepartment;

    /**
     * 变更负责人
     */
    @ExcelTitleName(title = "变更负责人", order = 8)
    private String changeCommander;
    /**
     * 变更供应商：供应商ID+供应商名称
     */
    @ExcelTitleName(title = "变更供应商", order = 9)
    private String supplier;

    /**
     * 变更原因
     */
    @ExcelTitleName(title = "变更原因", order = 10)
    private String changeReason;

    /**
     * 变更内容
     */
    @ExcelTitleName(title = "变更内容", order = 11)
    private String changeContent;

    /**
     * 变更潜在风险描述
     */
    @ExcelTitleName(title = "变更潜在风险描述", order = 12)
    private String changeRiskDesc;

    /**
     * 变更收益类型
     */
    @ExcelTitleName(title = "变更收益类型", order = 13)
    private String changeProfit;

    /**
     * 变更收益说明
     */
    @ExcelTitleName(title = "变更收益说明", order = 14)
    private String changeProfitDesc;

    /**
     * 变更商品,商品名称
     */
    @ExcelTitleName(title = "变更商品", order = 15)
    private String changeItem;

    /**
     * SPUID
     */
    @ExcelTitleName(title = "SPUID", order = 16)
    private String SPUId;

    /**
     * 品控类目
     */
    @ExcelTitleName(title = "品控类目", order = 17)
    private String qcCategory;

    /**
     * 物理类目
     */
    @ExcelTitleName(title = "物理类目", order = 18)
    private String phyCategory;

    /**
     * 商品立项类型，0-正常立项商品，2-特殊免立项商品 3-组合装
     */
    @ExcelTitleName(title = "商品立项类型", order = 19)
    private Integer itemSetupType;

    /**
     * 经营形式，0-自营，3-严选贴牌代销，4-他方品牌代销，5-代销2.0
     */
    @ExcelTitleName(title = "经营形式", order = 20)
    private Integer businessForm;
    /**
     * 商品状态，0-未上架，1-未上架，2-已上架，4-预上架
     */
    @ExcelTitleName(title = "商品状态", order = 21)
    private String status;

    /**
     * 商品负责人
     */
    @ExcelTitleName(title = "商品负责人", order = 22)
    private String functionary;

    /**
     * 采购负责人
     */
    @ExcelTitleName(title = "采购负责人", order = 23)
    private String purchase;

    /**
     * SQE负责人
     */
    @ExcelTitleName(title = "SQE负责人", order = 24)
    private String goodsSqe;
    /**
     * 计划负责人
     */
    @ExcelTitleName(title = "计划负责人", order = 25)
    private String goodsProjectName;

    /**
     * 变更行动部门
     */
    @ExcelTitleName(title = "变更行动部门", order = 26)
    private String execDepartment;

    /**
     * 变更行动人
     */
    @ExcelTitleName(title = "变更行动人", order = 27)
    private String changeExecUser;

    /**
     * 行动项变更风险描述
     */
    @ExcelTitleName(title = "行动项变更风险描述", order = 28)
    private String changeExecRiskDesc;

    /**
     * 行动项
     */
    @ExcelTitleName(title = "行动项", order = 29)
    private String changeExecProject;

    /**
     * 变更验证措施
     */
    @ExcelTitleName(title = "变更验证措施", order = 30)
    private String changeChecking;
    /**
     * 行动完成时间
     */
    @ExcelTitleName(title = "行动完成时间", order = 31)
    private String changeExecFinishTime;

    /**
     * 行动完成情况
     */
    @ExcelTitleName(title = "行动完成情况", order = 32)
    private String changeExecFinishDesc;

    /**
     * 变更结论
     */
    @ExcelTitleName(title = "变更结论", order = 33)
    private String changeResult;

    /**
     * 变更完结时间
     */
    @ExcelTitleName(title = "变更完结时间", order = 34)
    private Integer changeEndTime;


    public static List<ExcelCell> init(ChangeFlowExcelDTO dto) {
        List<ExcelCell> cellInfo = new ArrayList<>();
        ExcelCell excelCell = new ExcelCell();
        excelCell.setCellType(ExcelCellType.TEXT);
        // 1.id
        excelCell.setValue(dto.getFlowId());
        cellInfo.add(excelCell);
        // 2.变更发起时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getCreateTime());
        cellInfo.add(excelCell);
        // 3.变更发起人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCreator());
        cellInfo.add(excelCell);
        // 4.变更主体
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeSubject());
        cellInfo.add(excelCell);
        // 5.变更类型，一级类型>二级类型
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeType());
        cellInfo.add(excelCell);
        // 6.变更等级
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeLevel());
        cellInfo.add(excelCell);
        // 7.变更负责部门名
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeDepartment());
        cellInfo.add(excelCell);
        // 8.变更负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCommander());
        cellInfo.add(excelCell);
        // 9.变更供应商
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getSupplier());
        cellInfo.add(excelCell);
        // 10.变更原因
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeReason());
        cellInfo.add(excelCell);
        // 11.变更内容
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeContent());
        cellInfo.add(excelCell);
        // 12.变更潜在风险描述
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeRiskDesc());
        cellInfo.add(excelCell);
        // 13.变更收益类型
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeProfit());
        cellInfo.add(excelCell);
        // 14.变更收益说明
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeProfitDesc());
        cellInfo.add(excelCell);
        // 15.变更商品,商品名称
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeItem());
        cellInfo.add(excelCell);
        // 16.SPUID
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getSPUId());
        cellInfo.add(excelCell);
        // 17.品控类目
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getQcCategory());
        cellInfo.add(excelCell);
        // 18.物理类目
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getPhyCategory());
        cellInfo.add(excelCell);
        // 19.商品立项类型.0-正常立项商品，2-特殊免立项商品 3-组合装
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getItemSetupType());
        cellInfo.add(excelCell);
        // 20.经营形式，0-自营，3-严选贴牌代销，4-他方品牌代销，5-代销2.0
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getBusinessForm());
        cellInfo.add(excelCell);
        // 21.商品状态，0-未上架，1-未上架，2-已上架，4-预上架
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getStatus());
        cellInfo.add(excelCell);
        // 22.商品负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getFunctionary());
        cellInfo.add(excelCell);
        // 23.采购负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getPurchase());
        cellInfo.add(excelCell);
        // 24.SQE负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getGoodsSqe());
        cellInfo.add(excelCell);
        // 25.计划负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getGoodsProject());
        cellInfo.add(excelCell);
        // 26.变更行动部门
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getExecDepartment());
        cellInfo.add(excelCell);
        // 27.变更行动人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecUser());
        cellInfo.add(excelCell);
        // 28.行动项变更风险描述
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecRiskDesc());
        cellInfo.add(excelCell);
        // 29.行动项
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecProject());
        cellInfo.add(excelCell);
        // 30.变更验证措施
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeChecking());
        cellInfo.add(excelCell);
        // 31.行动完成时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecFinishTime());
        cellInfo.add(excelCell);
        // 32.行动完成情况
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecFinishDesc());
        cellInfo.add(excelCell);
        // 33.变更结论
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeResult());
        cellInfo.add(excelCell);
        // 34.变更完结时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeEndTime());
        cellInfo.add(excelCell);

        return cellInfo;
    }
}