/**
 * @(#)QCService.java, 2022/12/2.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Strings;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.integration.qc.QcRpcService;
import com.netease.mail.yanxuan.change.integration.qc.meta.QcCategoryVO;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/12/2
 */
@Slf4j
@Component
public class QCService {

    @Autowired
    private QcRpcService qcRpcService;

    @Autowired
    private StringRedisTemplate redisTemplate;
    
    public List<QcCategoryVO> getQcCategoryListByItemId(Long itemId) {
        log.info("[QCService-getQcCategoryListByItemId] request of query={}", itemId);
        String key = String.format(CommonConstants.ITEM_QC_CATEGORY_CACHE, itemId);
        String result = redisTemplate.opsForValue().get(key);
        if (StringUtils.isNotBlank(result)) {
            log.info("[QCService-getQcCategoryListByItemId] response from redis, query QcCategoryList ={}", result);
            return JSON.parseArray(result, QcCategoryVO.class);
        }
        AjaxResponse<List<QcCategoryVO>> response = qcRpcService.getQcCategoryListByItemId(itemId);
        log.info("[QCService-getQcCategoryListByItemId] response of query QcCategoryList ={}",
            JSON.toJSONString(response));
        if (ResponseCodeEnum.SUCCESS.getCode() == response.getCode()) {
            redisTemplate.opsForValue().set(key, JSON.toJSONString(response.getData()),7, TimeUnit.DAYS);
            return response.getData();
        }
        log.error("[op:rpc-getQcCategoryListByItemId] query QcCategoryList failed, query={}, errMsg={}", itemId,
            response.getErrorMsg());
        return Collections.emptyList();
    }
    }