package com.netease.mail.yanxuan.change.integration.rpc;

import com.netease.yanxuan.user.ula.sdk.AuthClient;
import com.netease.yanxuan.user.ula.sdk.meta.bean.AuthenticateResult;
import com.netease.yanxuan.user.ula.sdk.meta.common.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserTicketClient {

    @Autowired
    private AuthClient authClient;

    /**
     * 用户鉴权
     * 
     * @param cookie（cookie中的字段）
     */
    public AuthenticateResult getUserInfo(String cookie) {
        Response<AuthenticateResult> authenticate = authClient.authenticate(cookie, false);
        return authenticate.getData();
    }

    /**
     * 用户鉴权
     * 
     * @param cookie（cookie中的字段）
     */
    public AuthenticateResult getFullUserInfo(String cookie) {
        Response<AuthenticateResult> authenticate = authClient.authenticate(cookie, true);
        return authenticate.getData();
    }
}
