/**
 * @(#)ChangeFlowExecServiceImpl.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.netease.mail.yanxuan.change.biz.service.ChangeFlowExecService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeExecRecordMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowExecVO;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
@Service
public class ChangeFlowExecServiceImpl implements ChangeFlowExecService {

    @Autowired
    private ChangeExecRecordMapper changeExecRecordMapper;

    @Override
    public List<ChangeFlowExecVO> getChangeFlowExecRecord(Long changeRecordId) {
        List<ChangeExecRecord> changeExecRecords = changeExecRecordMapper.selectByChangeRecordId(changeRecordId);
        if (CollectionUtils.isNotEmpty(changeExecRecords)) {
            return changeExecRecords.stream()
                .map(c -> ChangeFlowExecVO.builder().changeExecId(c.getId()).changeRecordId(c.getChangeRecordId())
                    .changeExecDepartment(c.getChangeExecDepartment()).changeExecUserType(c.getChangeExecUserType())
                    .changeExecUser(c.getChangeExecUser()).changeExecUserEmail(c.getChangeExecUserEmail())
                    .changeRiskDesc(c.getChangeRiskDesc()).changeExecProject(c.getChangeExecProject())
                    .changeChecking(c.getChangeChecking()).changeExecFinishTime(c.getChangeExecFinishTime())
                    .changeExecFinishDesc(c.getChangeExecFinishDesc())
                    .subFlowId(c.getSubFlowId()).build())
                .collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    public List<ChangeExecRecord> getChangeExecRecordList(Long changeRecordId) {
        return changeExecRecordMapper.selectByChangeRecordId(changeRecordId);
    }

    @Override
    public void batchSaveRecord(List<ChangeExecRecord> changeExecRecordList) {
        changeExecRecordMapper.insertList(changeExecRecordList);
    }

    @Override
    public Boolean update(ChangeExecRecord changeExecRecord) {
        return changeExecRecordMapper.updateByPrimaryKeySelective(changeExecRecord) > 0;
    }

    @Override
    public Integer deleteByChangeRecordId(Long changeRecordId) {
        return changeExecRecordMapper.deleteByBaseId(changeRecordId);
    }

    @Override
    public void saveRecord(ChangeExecRecord exec) {
        changeExecRecordMapper.insertSelective(exec);
    }

    @Override
    public List<Long> queryByExecUser(String changeExecUser) {
        return changeExecRecordMapper.queryByUser("%" + changeExecUser + "%");
    }

    @Override
    public List<ChangeExecRecord> getBySubFlowRecordId(Long subFlowRecordId) {
        if (subFlowRecordId == null) {
            return new ArrayList<>();
        }
        return changeExecRecordMapper.selectBySubFlowRecordId(subFlowRecordId);
    }

    @Override
    public List<ChangeExecRecord> getBySubFlowRecordIds(List<Long> subFlowRecordIds) {
        if (CollectionUtils.isEmpty(subFlowRecordIds)) {
            return new ArrayList<>();
        }
        return changeExecRecordMapper.selectBySubFlowRecordIds(subFlowRecordIds);
    }

    @Override
    public List<Long> querySubFlowRecordIdsByExecCondition(String changeExecUser, String changeExecDepartment) {
        // 如果两个条件都为空，返回空列表
        if (StringUtils.isBlank(changeExecUser) && StringUtils.isBlank(changeExecDepartment)) {
            return new ArrayList<>();
        }
        // 如果 changeExecUser 不为空，添加 LIKE 通配符
        String userCondition = StringUtils.isNotBlank(changeExecUser) ? "%" + changeExecUser + "%" : null;
        return changeExecRecordMapper.querySubFlowRecordIdsByExecCondition(userCondition, changeExecDepartment);
    }

    @Override
    public Integer deleteBySubFlowRecordId(Long subFlowRecordId) {
        if (subFlowRecordId == null) {
            return 0;
        }
        return changeExecRecordMapper.deleteBySubFlowRecordId(subFlowRecordId);
    }
}
