package com.netease.mail.yanxuan.change.integration.email.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public enum AllTaskFlowTypeEnum {

    /**
     * 临时措施
     */
    TEMPORARY_MEASURE(1,"临时措施"),

    /**
     * 纠正措施
     */
    CORRECT_MEASURE(2,"纠正措施"),

    /**
     * 验证结果
     */
    VERIFY_RESULT(3,"验证结果"),

    /**
     * 供应商惩罚措施工单
     */
    SUPPLIER_PUNISHMENT(4, "供应商惩罚措施"),

    /**
     * 批量事件工单
     */
    BATCH_EVENT(5, "批量事件");

    private Integer type;

    private String name;

    AllTaskFlowTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static String getName(Integer type) {
        List<AllTaskFlowTypeEnum> list = Arrays.stream(AllTaskFlowTypeEnum.values())
                .filter(e -> e.getType().equals(type)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(list)) {
            return list.get(0).getName();
        }
        return "";
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}
