package com.netease.mail.yanxuan.change.biz.biz;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowExecService;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowFileService;
import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowRecordService;
import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.FlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.IusService;
import com.netease.mail.yanxuan.change.biz.service.rpc.SupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.ius.IusRpcService;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.biz.util.PageUtils;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.constants.FlowTransitionType;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeResultEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubFlowStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.CreateSourceEnum;
import com.netease.mail.yanxuan.change.common.enums.FileTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowOperationTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.FlowxOperationEnum;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.common.util.DateUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowFile;
import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowRecord;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeRecordMapper;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeSubFlowRecordMapper;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeExecConfigReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowFile;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowListQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowListQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowSubmitReq;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowExecVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeSubFlowListVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeSubFlowOwnershipVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeSubFlowVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.PageVO;
import com.netease.mail.yanxuan.change.integration.flow.UserQueryDTO;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.IusUserInfoRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.FlowDataDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.base.UserReachDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.exec.InterfaceInputDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.exec.UserBaseContainerDTO;
import com.netease.yanxuan.flowx.sdk.meta.dto.flow.FlowCreateReqDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author TmindA
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class ChangeSubFlowBiz {

    private final ChangeSubFlowService changeSubFlowService;
    private final FlowService flowService;
    private final ChangeFlowExecService changeFlowExecService;
    private final ChangeFlowService changeFlowService;
    private final ChangeSubFlowRecordService changeSubFlowRecordService;
    private final ChangeSubFlowRecordMapper changeSubFlowRecordMapper;
    private final ChangeRecordMapper changeRecordMapper;
    private final ChangeFlowBiz changeFlowBiz;
    private final ChangeExecRecordBiz changeExecRecordBiz;
    private final DepartmentLeaderBiz departmentLeaderBiz;
    private final IusRpcService iusRpcService;
    private final IusService iusService;
    private final AppConfig appConfig;
    private final ChangeSubFlowFileService changeSubFlowFileService;
    private final SupplierSendService sendSupplierEmail;

    public UserBaseContainerDTO getOperator(InterfaceInputDTO interfaceInput) {
        log.info("[getOperator] interfaceInput:{}", JSON.toJSONString(interfaceInput));
        // 根据工单subFlowId获取审批人，创建工单时设置，唯一
        String subFlowId = interfaceInput.getPublicFieldDTO().getFlowMeta().getFlowId();
        String nodeId = interfaceInput.getPublicFieldDTO().getFlowMeta().getCurrNodeDataList().get(0).getNodeId();
        log.info("[getOperator] subFlowId:{}, nodeId:{}", subFlowId, nodeId);
        ChangeSubFlowRecord changeSubFlowRecord;
        changeSubFlowRecord = changeSubFlowRecordService.getBySubFlowId(subFlowId);
        log.info("[getOperator] first time get changeSubFlowRecord:{}", changeSubFlowRecord);
        // 创建工单后落库，此时审批人还未落库，工单平台无法查询到审批人，方法休眠500ms
        if (changeSubFlowRecord == null) {
            try {
                Thread.sleep(500);
                changeSubFlowRecord = changeSubFlowRecordService.getBySubFlowId(subFlowId);
                log.info("[getOperator] second time get changeSubFlowRecord:{}", changeSubFlowRecord);
            } catch (Exception e) {
                log.info("[getOperator] subFlowId:{}, nodeId:{}, e={}", subFlowId, nodeId, e);
            }
        }
        
        // 校验节点是否匹配，避免节点已变更但approver还未更新的情况
        int maxRetries = 2;
        int retryCount = 0;
        while (changeSubFlowRecord != null && !nodeId.equals(changeSubFlowRecord.getSubFlowNode()) && retryCount < maxRetries) {
            log.warn("[getOperator] subFlowId:{}, nodeId:{}, subFlowNode:{}, 节点不匹配，等待重试，retryCount:{}", 
                    subFlowId, nodeId, changeSubFlowRecord.getSubFlowNode(), retryCount);
            try {
                Thread.sleep(300);
                changeSubFlowRecord = changeSubFlowRecordService.getBySubFlowId(subFlowId);
                retryCount++;
            } catch (Exception e) {
                log.error("[getOperator] subFlowId:{}, nodeId:{}, 重试异常, e={}", subFlowId, nodeId, e);
                break;
            }
        }
        
        if (changeSubFlowRecord != null && !nodeId.equals(changeSubFlowRecord.getSubFlowNode())) {
            log.error("[getOperator] subFlowId:{}, nodeId:{}, subFlowNode:{}, 节点不匹配，已重试{}次，返回当前审批人", 
                    subFlowId, nodeId, changeSubFlowRecord.getSubFlowNode(), retryCount);
        }
        
        if (changeSubFlowRecord == null) {
            log.error("[getOperator] subFlowId:{}, nodeId:{}, 子工单记录不存在", subFlowId, nodeId);
            UserBaseContainerDTO userBaseContainer = new UserBaseContainerDTO();
            userBaseContainer.setUserList(new ArrayList<>());
            return userBaseContainer;
        }
        
        // 从approver字段获取审批人列表，反序列化JSON字符串
        String approverJson = changeSubFlowRecord.getApprover();
        List<UserReachDTO> totalUserList = new ArrayList<>();
        
        if (StringUtils.isNotBlank(approverJson)) {
            List<String> approvers = JSON.parseArray(approverJson, String.class);
            if (CollectionUtils.isNotEmpty(approvers)) {
                for (String approver : approvers) {
                    UserReachDTO userReachDTO = new UserReachDTO();
                    // 查询邮箱对应的名字
                    IusUserInfoRsp user = iusService.queryUserInfo(approver);
                    // 流程拓扑图，如果没查询到名字，以邮箱兜底
                    userReachDTO.setUserName(
                        user == null || StringUtils.isBlank(user.getName()) ? approver : user.getName());
                    userReachDTO.setUid(approver);
                    totalUserList.add(userReachDTO);
                }
            }
        }
        
        UserBaseContainerDTO userBaseContainer = new UserBaseContainerDTO();
        userBaseContainer.setUserList(totalUserList);
        return userBaseContainer;
    }


    //public String createAndSubmit(@Valid ChangeSubFlowCreateReq changeSubFlowCreateReq) {
    //    String uid = RequestLocalBean.getUid();
    //    String name = RequestLocalBean.getName();
    //    Map<String, Object> content = new HashMap<>(10);
    //    content.put("createUserName", uid);
    //    content.put("createUser", uid);
    //    content.put("createTime", System.currentTimeMillis());
    //    content.put("updateTime", System.currentTimeMillis());
    //    content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
    //    String flowName = "";
    //    // 组装工单创建数据
    //    FlowCreateReqDTO flowCreateReqDTO = buildFlowCreateReqDTO(ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), uid,
    //            JSON.toJSONString(content), FlowxOperationEnum.CREATE.getName(), name, flowName);
    //    // 创建工单
    //    String subFlowId = flowService.createFlow(flowCreateReqDTO);
    //
    //    ChangeExecRecord execRecord = new ChangeExecRecord();
    //    changeSubFlowService.createSubFlow(execRecord);
    //    return "";
    //}

    private FlowCreateReqDTO buildFlowCreateReqDTO(String topoId, String uid, String content, String operateResult,
                                                   String name, String flowName) {
        FlowCreateReqDTO flowCreateReqDTO = new FlowCreateReqDTO();
        flowCreateReqDTO.setTopoId(topoId);
        flowCreateReqDTO.setUid(uid);
        flowCreateReqDTO.setUserName(name);
        flowCreateReqDTO.setOperateResult(operateResult);
        flowCreateReqDTO.setWorkOrderId(StringUtils.joinWith("-", topoId, UUID.randomUUID().toString()));
        flowCreateReqDTO.setContent(content);
        flowCreateReqDTO.setFlowName(flowName);
        return flowCreateReqDTO;
    }

    public List<ChangeExecRecord> list(Integer page, Integer pageSize) {
        return changeSubFlowService.query((page - 1) * pageSize, pageSize);
    }

    /**
     * 子流程提交
     * @param changeSubFlowSubmitReq 子流程提交请求
     * @return 下一节点ID
     */
    public String submitSubFlow(ChangeSubFlowSubmitReq changeSubFlowSubmitReq) {
        log.info("[submitSubFlow] changeSubFlowSubmitReq:{}", JSON.toJSONString(changeSubFlowSubmitReq));
        String subFlowId = changeSubFlowSubmitReq.getSubFlowId();
        
        // 通过子流程工单ID查询行动工单记录
        ChangeSubFlowRecord subFlowRecord = changeSubFlowRecordService.getBySubFlowId(subFlowId);
        Assert.notNull(subFlowRecord, "行动工单记录不存在");
        
        // 检查工单节点（从行动工单获取）
        String currentNode = subFlowRecord.getSubFlowNode();
        this.checkNode(currentNode, Collections.singletonList(changeSubFlowSubmitReq.getCurrentNodeId()));
        
        String uid = RequestLocalBean.getUid();
        // 验证执行人权限：检查当前用户是否在行动工单的审批人列表中（JSON格式：["user1@example.com", "user2@example.com"]）
        //if (StringUtils.isBlank(subFlowRecord.getApprover())
        //        || !subFlowRecord.getApprover().contains("\"" + uid + "\"")) {
        //    throw ExceptionFactory.createBiz(ResponseCode.NO_AUTH, ResponseCode.NO_AUTH.getMsg());
        //}
        
        // 获取工单详情
        FlowDataDTO flowDataDTO = flowService.flowDetail(subFlowId);
        if (flowDataDTO == null) {
            throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "子流程工单查询错误，不存在");
        }
        
        return checkUpdateAndSubmit(subFlowId, flowDataDTO, uid, subFlowRecord, currentNode, changeSubFlowSubmitReq);
    }

    /**
     * 检查并提交子流程节点
     */
    private String checkUpdateAndSubmit(String subFlowId, FlowDataDTO flowDataDTO, String uid, 
                                       ChangeSubFlowRecord subFlowRecord, String currentNode, ChangeSubFlowSubmitReq changeSubFlowSubmitReq) {
        ChangeFlowEnum node = ChangeFlowEnum.getByNodeId(currentNode);
        Assert.notNull(node, "节点配置不存在");
        
        // 记录当前节点（用于日志对比）
        String oldNodeId = currentNode;
        String oldNodeName = node.getName();
        
        log.info("[checkUpdateAndSubmit] 子单流转开始 >>> subFlowId:{}, 当前节点ID:{}, 当前节点名称:{}", 
                subFlowId, oldNodeId, oldNodeName);
        log.debug("[checkUpdateAndSubmit] 提交参数:{}", JSON.toJSONString(changeSubFlowSubmitReq));
        
        // 构建工单内容
        Map<String, Object> content = buildFlowContent();
        
        switch (node) {
            case CHANGE_SUB_FLOW_START:
                // 确认行动方案节点：删除旧的行动项，重新创建
                List<ChangeExecConfigReq> changeExecProjectList = changeSubFlowSubmitReq.getChangeExecProjectList();
                
                // 校验行动项列表不能为空
                if (CollectionUtils.isEmpty(changeExecProjectList)) {
                    throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动项列表不能为空");
                }
                
                // 校验行动项列表：所有行动项必须是同一个部门+人的组合，且与子单记录一致
                String expectedDepartment = subFlowRecord.getChangeExecDepartment();
                String expectedUserEmail = subFlowRecord.getChangeExecUserEmail();
                
                // 校验所有行动项的必填字段和部门+邮箱必须与子单记录一致
                changeExecProjectList.forEach(execConfig -> {
                    String dept = execConfig.getChangeExecDepartment();
                    String userEmail = execConfig.getChangeExecUserEmail();
                    
                    if (StringUtils.isBlank(dept) || StringUtils.isBlank(userEmail)) {
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                                "行动项中部门或行动人邮箱不能为空");
                    }
                    
                    if (!expectedDepartment.equals(dept) || !expectedUserEmail.equals(userEmail)) {
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                                String.format("行动项的部门+人组合必须与子单记录一致。子单记录：部门[%s]，行动人[%s]；当前行动项：部门[%s]，行动人[%s]", 
                                        expectedDepartment, expectedUserEmail, dept, userEmail));
                    }
                });
                
                // 校验所有行动项的必填字段（使用公共方法）
                changeExecRecordBiz.validateChangeExecProjectRequiredFields(changeExecProjectList, true);
                
                // 删除子单下所有行动项
                changeFlowExecService.deleteBySubFlowRecordId(subFlowRecord.getId());
                
                // 根据前端传递的行动项列表重新创建
                List<ChangeExecRecord> newExecRecords = changeExecRecordBiz.buildChangeExecRecord(
                    subFlowRecord.getChangeRecordId(), changeExecProjectList, subFlowId, subFlowRecord.getId());
                newExecRecords.forEach(changeFlowExecService::saveRecord);
                
                // 检查是否需要审批，通过paramMap控制流转方向
                Map<String, Object> paramMap = new HashMap<>();
                String nextNodeId;
                
                if (needApprove(expectedDepartment)) {
                    // 需要审批：流转到审批行动方案节点，设置上级领导为审批人
                    log.info("[CHANGE_SUB_FLOW_START] 部门[{}]需要审批，等待上级审批", expectedDepartment);
                    paramMap.put("type", FlowTransitionType.TYPE_APPROVED);
                    
                    // 提交到审批行动方案节点
                    nextNodeId = flowService.submitFlowWithParamMap(subFlowId, flowDataDTO, uid,
                            ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), paramMap,
                            FlowxOperationEnum.SUBMIT.getName(), "提交工单", subFlowRecord.getCreateTime());
                    
                    // 更新子单记录
                    subFlowRecord.setSubFlowNode(nextNodeId);
                    subFlowRecord.setStatus(ChangeSubFlowStatusEnum.WAIT_APPROVE_ACTION_PLAN.getStatus());
                    subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
                    
                    // 获取上级领导并设置为审批人
                    String execUserEmail = subFlowRecord.getChangeExecUserEmail();
                    if (StringUtils.isBlank(execUserEmail)) {
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "行动人邮箱不能为空");
                    }
                    String leaderEmail = departmentLeaderBiz.getDepartmentLeader(execUserEmail);
                    if (StringUtils.isBlank(leaderEmail)) {
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                                String.format("行动人[%s]的部门上级领导不存在", execUserEmail));
                    }
                    subFlowRecord.setApprover(JSON.toJSONString(Collections.singletonList(leaderEmail)));
                    
                    log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-审批行动方案", 
                            subFlowId, oldNodeId, oldNodeName, nextNodeId);
                } else {
                    // 不需要审批：直接跳到审批变更方案节点，审批人保持为行动人自己
                    log.info("[CHANGE_SUB_FLOW_START] 部门[{}]不需要审批，自动跳过审批", expectedDepartment);
                    paramMap.put("type", FlowTransitionType.TYPE_SKIP);
                    
                    // 提交到审批变更方案节点
                    nextNodeId = flowService.submitFlowWithParamMap(subFlowId, flowDataDTO, uid,
                            ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), paramMap,
                            FlowxOperationEnum.SUBMIT.getName(), "提交工单", subFlowRecord.getCreateTime());
                    
                    // 更新子单记录
                    subFlowRecord.setSubFlowNode(nextNodeId);
                    subFlowRecord.setStatus(ChangeSubFlowStatusEnum.WAIT_APPROVE_CHANGE_PLAN.getStatus());
                    subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
                    // todo:非名单中部门无需审批，行动人确认提交后邮件同步负责人上级对应变更信息
                    
                    log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-审批变更方案 (自动跳过审批)", 
                            subFlowId, oldNodeId, oldNodeName, nextNodeId);
                }
                
                changeSubFlowRecordService.update(subFlowRecord);
                return nextNodeId;
                
            case CHANGE_SUB_FLOW_SUBMIT:
                // 审批行动方案节点
                Boolean approved = changeSubFlowSubmitReq.getApproved();
                if (approved == null) {
                    throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "审批结果不能为空");
                }
                
                // 审批不通过时，拒绝原因必填
                if (!approved) {
                    String rejectReason = changeSubFlowSubmitReq.getRejectReason();
                    if (StringUtils.isBlank(rejectReason)) {
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "拒绝原因不能为空");
                    }
                    subFlowRecord.setRejectReason(rejectReason);
                    log.info("[CHANGE_SUB_FLOW_SUBMIT] 审批不通过，subFlowId:{}, rejectReason:{}", subFlowId, rejectReason);
                }
                
                // 使用paramMap控制流转方向（通过/不通过）
                Map<String, Object> approveParamMap = new HashMap<>();
                approveParamMap.put("type", approved ? FlowTransitionType.TYPE_APPROVED : FlowTransitionType.TYPE_BACK);
                
                String remark = approved ? "审批通过" : "审批不通过";
                String approveNodeId = flowService.submitFlowWithParamMap(subFlowId, flowDataDTO, uid,
                        ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), approveParamMap,
                        FlowxOperationEnum.SUBMIT.getName(), remark, subFlowRecord.getCreateTime());
                
                // 更新行动工单
                subFlowRecord.setSubFlowNode(approveNodeId);
                subFlowRecord.setStatus(approved 
                        ? ChangeSubFlowStatusEnum.WAIT_APPROVE_CHANGE_PLAN.getStatus()
                        : ChangeSubFlowStatusEnum.WAIT_CONFIRM_ACTION_PLAN.getStatus());
                subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
                changeSubFlowRecordService.update(subFlowRecord);
                String approveNodeName = approved ? "审批变更方案" : "确认行动方案";
                log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-{}, 审批结果:{}", 
                        subFlowId, oldNodeId, oldNodeName, approveNodeId, approveNodeName, approved ? "通过" : "不通过");
                return approveNodeId;
                
            case CHANGE_SUB_FLOW_EXE:
                // 审批变更方案节点
                Boolean execApproved = changeSubFlowSubmitReq.getApproved();
                if (execApproved == null) {
                    throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "审批结果不能为空");
                }
                
                // 使用paramMap控制流转方向
                Map<String, Object> execParamMap = new HashMap<>();
                String execNodeId;
                
                if (execApproved) {
                    // 审批通过：流转到提交执行结果节点
                    log.info("[CHANGE_SUB_FLOW_EXE] 审批通过，subFlowId:{}", subFlowId);
                    execParamMap.put("type", FlowTransitionType.TYPE_APPROVED);
                    
                    // 提交到提交执行结果节点
                    execNodeId = flowService.submitFlowWithParamMap(subFlowId, flowDataDTO, uid,
                            ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), execParamMap,
                            FlowxOperationEnum.SUBMIT.getName(), "审批通过", subFlowRecord.getCreateTime());
                    
                    // 更新子单记录
                    subFlowRecord.setSubFlowNode(execNodeId);
                    subFlowRecord.setStatus(ChangeSubFlowStatusEnum.WAIT_SUBMIT_RESULT.getStatus());
                    subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
                    changeSubFlowRecordService.update(subFlowRecord);
                    
                    log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-提交执行结果, 审批结果:通过", 
                            subFlowId, oldNodeId, oldNodeName, execNodeId);
                    
                    // 检查所有子单是否都已到达提交执行结果节点，如果是则流转主工单
                    if (checkAllSubFlowsApproved(subFlowRecord.getChangeRecordId())) {
                        submitMainFlowAfterAllSubFlowsApproved(subFlowRecord.getChangeRecordId());
                        log.info("[CHANGE_SUB_FLOW_EXE] 所有子单均已到达提交执行结果节点，主工单已流转");
                    }
                } else {
                    // 审批不通过：回退到确认行动方案节点，拒绝原因必填
                    String execRejectReason = changeSubFlowSubmitReq.getRejectReason();
                    if (StringUtils.isBlank(execRejectReason)) {
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "拒绝原因不能为空");
                    }
                    subFlowRecord.setRejectReason(execRejectReason);
                    log.info("[CHANGE_SUB_FLOW_EXE] 审批不通过，subFlowId:{}, rejectReason:{}", subFlowId, execRejectReason);
                    execParamMap.put("type", FlowTransitionType.TYPE_BACK);
                    
                    // 提交到确认行动方案节点
                    execNodeId = flowService.submitFlowWithParamMap(subFlowId, flowDataDTO, uid,
                            ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), execParamMap,
                            FlowxOperationEnum.SUBMIT.getName(), "审批不通过", subFlowRecord.getCreateTime());
                    
                    // 更新子单记录
                    subFlowRecord.setSubFlowNode(execNodeId);
                    subFlowRecord.setStatus(ChangeSubFlowStatusEnum.CANCELLED.getStatus());
                    subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
                    changeSubFlowRecordService.update(subFlowRecord);
                    
                    log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-确认行动方案, 审批结果:不通过", 
                            subFlowId, oldNodeId, oldNodeName, execNodeId);
                }
                
                return execNodeId;
                
            case CHANGE_SUB_FLOW_CONFIRM:
                // 提交执行结果节点，填写变更结论
                // 判断主单节点必须是NEW_CHANGE_FLOW_EXE，否则不允许提交
                ChangeRecord mainRecordForCheck = changeRecordMapper.selectByPrimaryKey(subFlowRecord.getChangeRecordId());
                if (mainRecordForCheck == null) {
                    throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "主工单不存在");
                }
                String mainFlowNode = mainRecordForCheck.getFlowNode();
                if (!ChangeFlowEnum.NEW_CHANGE_FLOW_EXE.getNodeId().equals(mainFlowNode)) {
                    throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                            String.format("主工单未到达执行变更方案节点，当前主单节点：%s，不允许提交执行结果", mainFlowNode));
                }
                
                Integer subFlowChangeResult = changeSubFlowSubmitReq.getChangeResult();
                ChangeResultEnum changeResultEnum = ChangeResultEnum.getByValue(subFlowChangeResult);
                if (changeResultEnum == null) {
                    throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "变更结论类型错误");
                }

                // 填写变更结论和备注到子单记录
                subFlowRecord.setChangeResult(subFlowChangeResult);
                subFlowRecord.setRemark(changeSubFlowSubmitReq.getRemark());
                
                // 处理子单的变更结果文件（所有结论类型都需要保存文件）
                List<ChangeFlowFile> subFlowResultFiles = changeSubFlowSubmitReq.getChangeResultFiles();
                if (CollectionUtils.isNotEmpty(subFlowResultFiles)) {
                    // 先删除旧文件
                    changeSubFlowFileService.deleteBySubFlowRecordIdAndType(subFlowRecord.getId(), FileTypeEnum.CHANGE_RESULT_INFO);
                    // 保存新文件
                    List<ChangeSubFlowFile> fileList = buildChangeFileRecordForSubFlow(
                            subFlowRecord.getId(), subFlowResultFiles, FileTypeEnum.CHANGE_RESULT_INFO.getType());
                    fileList.forEach(changeSubFlowFileService::saveRecord);
                }
                
                switch (changeResultEnum) {
                    case FINISH_ALL:
                    case FINISH_PART:
                        return handleSubFlowFinish(subFlowRecord, changeSubFlowSubmitReq, flowDataDTO, uid, content, changeResultEnum, oldNodeId, oldNodeName);
                        
                    case CANCEL:
                        return handleSubFlowCancel(subFlowRecord, changeSubFlowSubmitReq, flowDataDTO, uid, content, oldNodeId, oldNodeName);
                        
                    case DELAY:
                        return handleSubFlowDelay(subFlowRecord, changeSubFlowSubmitReq, oldNodeId, oldNodeName);
                        
                    default:
                        throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "不支持的变更结论类型");
                }
                
            default:
                log.warn("[checkUpdateAndSubmit] 不支持的子流程节点类型：subFlowId:{}, nodeId:{}, 节点名称:{}", 
                        subFlowId, currentNode, node.getName());
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "不支持的子流程节点类型");
        }
    }

    /**
     * 检查节点是否匹配
     */
    private void checkNode(String currentNode, List<String> expectedNodes) {
        if (!expectedNodes.contains(currentNode)) {
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                    String.format("当前节点[%s]与预期节点[%s]不匹配", currentNode, expectedNodes));
        }
    }

    /**
     * 判断部门是否应该跳过审批
     * 
     * @param department 部门名称
     * @return true 表示应该跳过审批（不在需要审批的部门列表中）
     */
    /**
     * 判断部门是否需要审批
     * 
     * @param department 部门名称
     * @return true 表示需要审批（在配置的部门列表中）
     */
    private boolean needApprove(String department) {
        if (StringUtils.isBlank(department)) {
            return false;
        }
        List<String> needApproveDepts = appConfig.getNeedApproveDepartments();
        // 如果没有配置或配置为空，默认都不需要审批
        if (CollectionUtils.isEmpty(needApproveDepts)) {
            return false;
        }
        // 检查部门是否在需要审批的列表中
        return needApproveDepts.stream()
                .filter(StringUtils::isNotBlank)
                .map(String::trim)
                .anyMatch(dept -> dept.equals(department.trim()));
    }

    /**
     * 处理子单完成（FINISH_ALL / FINISH_PART）
     */
    private String handleSubFlowFinish(ChangeSubFlowRecord subFlowRecord, ChangeSubFlowSubmitReq req,
                                       FlowDataDTO flowDataDTO, String uid, Object content, ChangeResultEnum resultStatus,
                                       String oldNodeId, String oldNodeName) {
        // 提交子单流程到结束节点，使用 paramMap 方式，type=1 表示通过
        Map<String, Object> finishParamMap = new HashMap<>();
        finishParamMap.put("type", FlowTransitionType.TYPE_APPROVED);
        String endNodeId = flowService.submitFlowWithParamMap(subFlowRecord.getSubFlowId(), flowDataDTO, uid,
                ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), finishParamMap,
                FlowxOperationEnum.SUBMIT.getName(), "提交执行结果", subFlowRecord.getCreateTime());
        
        // 更新子单状态为FINISHED
        subFlowRecord.setSubFlowNode(endNodeId);
        subFlowRecord.setStatus(ChangeSubFlowStatusEnum.FINISHED.getStatus());
        subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
        changeSubFlowRecordService.update(subFlowRecord);
        
        log.info("[handleSubFlowFinish] 子单完成，subFlowId:{}, result:{}", subFlowRecord.getSubFlowId(), resultStatus);
        log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-结束, 变更结论:{}", 
                subFlowRecord.getSubFlowId(), oldNodeId, oldNodeName, endNodeId, resultStatus.getDesc());
        
        // 发送邮件
        sendSubFlowFinishEmail(subFlowRecord);
        
        // 检查所有子单是否都已完成，如果是则流转主工单
        if (checkAllSubFlowsFinishedForMainFlow(subFlowRecord.getChangeRecordId())) {
            submitMainFlowAfterAllSubFlowsFinished(subFlowRecord.getChangeRecordId());
            log.info("[handleSubFlowFinish] 所有子单均已完成，主工单已流转");
        }
        
        return endNodeId;
    }

    /**
     * 处理子单取消（CANCEL）
     */
    private String handleSubFlowCancel(ChangeSubFlowRecord subFlowRecord, ChangeSubFlowSubmitReq req,
                                       FlowDataDTO flowDataDTO, String uid, Object content,
                                       String oldNodeId, String oldNodeName) {
        // 1. 取消原因必填
        if (StringUtils.isBlank(req.getCancelReason())) {
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "变更取消原因不可为空");
        }
        
        // 2. 保存取消原因
        subFlowRecord.setCancelReason(req.getCancelReason());
        
        // 3. 提交子单流程到结束节点，使用 paramMap 方式，type=1 表示通过
        Map<String, Object> cancelParamMap = new HashMap<>();
        cancelParamMap.put("type", FlowTransitionType.TYPE_APPROVED);
        String cancelNodeId = flowService.submitFlowWithParamMap(subFlowRecord.getSubFlowId(), flowDataDTO, uid,
                ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId(), JSON.toJSONString(content), cancelParamMap,
                FlowxOperationEnum.SUBMIT.getName(), "取消工单", subFlowRecord.getCreateTime());
        
        // 5. 更新子单状态为CANCELLED
        subFlowRecord.setSubFlowNode(cancelNodeId);
        subFlowRecord.setStatus(ChangeSubFlowStatusEnum.CANCELLED.getStatus());
        subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
        changeSubFlowRecordService.update(subFlowRecord);
        
        log.info("[handleSubFlowCancel] 子单已取消，subFlowId:{}, reason:{}", subFlowRecord.getSubFlowId(), req.getCancelReason());
        log.info("[checkUpdateAndSubmit] 子单流转完成 <<< subFlowId:{}, 原节点:{}-{}, 新节点:{}-结束, 变更结论:取消", 
                subFlowRecord.getSubFlowId(), oldNodeId, oldNodeName, cancelNodeId);
        
        // 发送邮件
        sendSubFlowFinishEmail(subFlowRecord);
        
        // 检查所有子单是否都已完成，如果是则流转主工单
        if (checkAllSubFlowsFinishedForMainFlow(subFlowRecord.getChangeRecordId())) {
            submitMainFlowAfterAllSubFlowsFinished(subFlowRecord.getChangeRecordId());
            log.info("[handleSubFlowCancel] 所有子单均已完成，主工单已流转");
        }
        
        return cancelNodeId;
    }

    /**
     * 处理子单延期（DELAY）
     */
    private String handleSubFlowDelay(ChangeSubFlowRecord subFlowRecord, ChangeSubFlowSubmitReq req,
                                      String oldNodeId, String oldNodeName) {
        // 验证延期时间
        Long changeConfirmResultTime = req.getChangeConfirmResultTime();
        Long tomorrowSpecificTime = DateUtils.getTomorrowSpecificTime("00:00:00");
        if (changeConfirmResultTime == null || changeConfirmResultTime < tomorrowSpecificTime) {
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "时间不可晚于下次执行时间");
        }
        
        // 更新子单延期时间，不流转工单
        subFlowRecord.setChangeConfirmResultTime(changeConfirmResultTime);
        subFlowRecord.setUpdateTime(DateUtils.getCurrentTime());
        changeSubFlowRecordService.update(subFlowRecord);

        // todo:延期需要重新发邮件，改变执行邮件状态
        
        log.info("[handleSubFlowDelay] 子单延期，subFlowId:{}, delayTime:{}", subFlowRecord.getSubFlowId(), changeConfirmResultTime);
        log.info("[checkUpdateAndSubmit] 子单延期（不流转）<<< subFlowId:{}, 节点保持:{}-{}, 延期时间:{}", 
                subFlowRecord.getSubFlowId(), oldNodeId, oldNodeName, changeConfirmResultTime);
        
        return null;
    }

    /**
     * 构建子单文件记录
     * 
     * @param subFlowRecordId 子单ID
     * @param files 文件列表
     * @param type 文件类型
     * @return 文件记录列表
     */
    private List<ChangeSubFlowFile> buildChangeFileRecordForSubFlow(Long subFlowRecordId, 
                                                                    List<ChangeFlowFile> files, Integer type) {
        return files.stream().map(f -> {
            ChangeSubFlowFile file = new ChangeSubFlowFile();
            file.setSubFlowRecordId(subFlowRecordId);
            file.setFileType(type);
            file.setFileName(f.getFileName());
            file.setFileUrl(f.getFileUrl());
            file.setCreateTime(DateUtils.getCurrentTime());
            file.setUpdateTime(DateUtils.getCurrentTime());
            return file;
        }).collect(Collectors.toList());
    }

    /**
     * 检查主工单下所有子单是否都已到达提交执行结果节点
     * 条件：status = WAIT_SUBMIT_RESULT 且 subFlowNode = CHANGE_SUB_FLOW_CONFIRM
     * 
     * @param changeRecordId 主工单ID
     * @return true 表示所有子单都已到达提交执行结果节点
     */
    private boolean checkAllSubFlowsApproved(Long changeRecordId) {
        // 查询该主工单下所有子单
        List<ChangeSubFlowRecord> allSubFlows = changeSubFlowRecordMapper.selectByChangeRecordId(changeRecordId);
        if (CollectionUtils.isEmpty(allSubFlows)) {
            return false;
        }
        
        // 检查是否所有子单都满足条件：status = WAIT_SUBMIT_RESULT 且 subFlowNode = CHANGE_SUB_FLOW_CONFIRM
        return allSubFlows.stream().allMatch(subFlow -> 
            ChangeSubFlowStatusEnum.WAIT_SUBMIT_RESULT.getStatus().equals(subFlow.getStatus())
            && ChangeFlowEnum.CHANGE_SUB_FLOW_CONFIRM.getNodeId().equals(subFlow.getSubFlowNode())
        );
    }
    
    /**
     * 构建工单提交内容（包含 updateTime 和 FLOW_OPERATION_KEY）
     * 
     * @return 工单提交内容 Map
     */
    private Map<String, Object> buildFlowContent() {
        Map<String, Object> content = new HashMap<>(CommonConstants.INIT_HASH_MAP_SIZE);
        content.put("updateTime", System.currentTimeMillis());
        content.put(CommonConstants.FLOW_OPERATION_KEY, FlowOperationTypeEnum.PASS.getValue());
        return content;
    }
    
    /**
     * 所有子单审批变更方案通过后，流转主工单到部门负责人审批节点
     * 
     * @param changeRecordId 主工单ID
     */
    private void submitMainFlowAfterAllSubFlowsApproved(Long changeRecordId) {
        // 查询主工单
        ChangeRecord changeRecord = changeRecordMapper.selectByPrimaryKey(changeRecordId);
        if (changeRecord == null) {
            log.error("[submitMainFlowAfterAllSubFlowsApproved] 主工单不存在，changeRecordId:{}", changeRecordId);
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "主工单不存在");
        }
        
        // 验证主工单当前节点
        String currentNode = changeRecord.getFlowNode();
        if (!ChangeFlowEnum.NEW_CHANGE_FLOW_CONFIRM_EXEC_PLAN.getNodeId().equals(currentNode)) {
            throw ExceptionFactory.createBiz(ResponseCode.NODE_ERROR, 
                    String.format("主工单当前节点不是确认变更方案节点，无法流转。当前节点：%s", currentNode));
        }
        
        try {
            Long flowId = changeRecord.getFlowId();
            String uid = RequestLocalBean.getUid();
            if (StringUtils.isBlank(uid)) {
                uid = "system";
            }
            
            // 获取工单详情
            FlowDataDTO flowDataDTO = flowService.flowDetail(flowId.toString());
            if (flowDataDTO == null) {
                throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "工单查询错误，不存在");
            }
            
            // 构建提交内容
            Map<String, Object> content = buildFlowContent();
            
            // 使用paramMap控制流转方向（所有子单审批通过）
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("type", FlowTransitionType.TYPE_APPROVED);
            
            // 流转主工单到部门负责人审批节点
            String ownerApproveNodeId = flowService.submitFlowWithParamMap(flowId.toString(), flowDataDTO, uid,
                    ChangeFlowEnum.NEW_CHANGE_FLOW.getTopoId(), JSON.toJSONString(content), paramMap,
                    FlowxOperationEnum.SUBMIT.getName(), "所有子单审批通过，主工单流转", changeRecord.getCreateTime());
            
            changeRecord.setFlowNode(ownerApproveNodeId);
            changeRecord.setState(ChangeStatusEnum.WAIT_DEPT_LEADER_APPROVE.getStatus());
            changeRecord.setUpdateTime(DateUtils.getCurrentTime());
            
            // 获取变更负责人的上级领导并设置为审批人
            String changeCommander = changeRecord.getChangeCommander();
            if (StringUtils.isBlank(changeCommander)) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "变更负责人邮箱不能为空");
            }
            String leaderEmail = departmentLeaderBiz.getDepartmentLeader(changeCommander);
            if (StringUtils.isBlank(leaderEmail)) {
                throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                        String.format("变更负责人[%s]的部门上级领导不存在", changeCommander));
            }
            // 设置审批人为上级领导（JSON 数组格式）
            changeRecord.setApprover(JSON.toJSONString(Collections.singletonList(leaderEmail)));
            changeFlowService.updateRecord(changeRecord);
            
            log.info("[submitMainFlowAfterAllSubFlowsApproved] 主工单流转成功，flowId:{}, nextNodeId:{}, approver:{}", 
                    flowId, ownerApproveNodeId, leaderEmail);
        } catch (Exception e) {
            log.error("[submitMainFlowAfterAllSubFlowsApproved] 主工单流转失败，changeRecordId:{}", changeRecordId, e);
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, 
                    String.format("主工单流转失败：%s", e.getMessage()));
        }
    }
    
    /**
     * 所有子单执行完成后，流转主工单到确认执行结果节点
     * 
     * @param changeRecordId 主工单ID
     */
    private void submitMainFlowAfterAllSubFlowsFinished(Long changeRecordId) {
        // 查询主工单
        ChangeRecord changeRecord = changeRecordMapper.selectByPrimaryKey(changeRecordId);
        if (changeRecord == null) {
            log.error("[submitMainFlowAfterAllSubFlowsFinished] 主工单不存在，changeRecordId:{}", changeRecordId);
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST, "主工单不存在");
        }

        // 验证主工单当前节点
        String currentNode = changeRecord.getFlowNode();
        if (!ChangeFlowEnum.NEW_CHANGE_FLOW_EXE.getNodeId().equals(currentNode)) {
            log.warn("[submitMainFlowAfterAllSubFlowsFinished] 主工单当前节点不是执行变更方案节点，无法流转。当前节点：{}", currentNode);
            return;
        }

        try {
            Long flowId = changeRecord.getFlowId();
            String uid = RequestLocalBean.getUid();
            if (StringUtils.isBlank(uid)) {
                uid = "system";
            }
            String name = RequestLocalBean.getName();
            if (StringUtils.isBlank(name)) {
                name = "系统";
            }

            // 获取工单详情
            FlowDataDTO flowDataDTO = flowService.flowDetail(flowId.toString());
            if (flowDataDTO == null) {
                throw ExceptionFactory.createBiz(ResponseCode.DETAIL_FLOW_ERROR, "工单查询错误，不存在");
            }

            // 构建提交内容
            Map<String, Object> content = buildFlowContent();

            // 使用paramMap控制流转方向（所有子单执行结果完成）
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("type", FlowTransitionType.TYPE_APPROVED);

            // 流转主工单到确认变更结果节点
            String confirmNodeId = flowService.submitFlowWithParamMap(flowId.toString(), flowDataDTO, uid,
                    ChangeFlowEnum.NEW_CHANGE_FLOW.getTopoId(), JSON.toJSONString(content), paramMap,
                    FlowxOperationEnum.SUBMIT.getName(), "所有子单执行结果完成，主工单流转", changeRecord.getCreateTime());

            changeRecord.setFlowNode(confirmNodeId);
            changeRecord.setState(ChangeStatusEnum.WAIT_CONFIRM_EXEC_RESULT.getStatus());
            changeRecord.setUpdateTime(DateUtils.getCurrentTime());
            changeFlowService.updateRecord(changeRecord);

            log.info("[submitMainFlowAfterAllSubFlowsFinished] 主工单流转成功，flowId:{}, nextNodeId:{}, state:{}",
                    flowId, confirmNodeId, ChangeStatusEnum.WAIT_CONFIRM_EXEC_RESULT.getStatus());
        } catch (Exception e) {
            log.error("[submitMainFlowAfterAllSubFlowsFinished] 主工单流转失败，changeRecordId:{}", changeRecordId, e);
            throw ExceptionFactory.createBiz(ResponseCode.BAD_REQUEST,
                    String.format("主工单流转失败：%s", e.getMessage()));
        }
    }
    
    /**
     * 检查主工单下所有子单是否都已完成
     * 以节点为准：如果节点是结束节点（9999），则认为已完成，允许主工单流转
     * 
     * @param changeRecordId 主工单ID
     * @return true 表示所有子单都已完成
     */
    private boolean checkAllSubFlowsFinishedForMainFlow(Long changeRecordId) {
        // 查询该主工单下所有子单
        List<ChangeSubFlowRecord> allSubFlows = changeSubFlowRecordMapper.selectByChangeRecordId(changeRecordId);
        if (CollectionUtils.isEmpty(allSubFlows)) {
            return false;
        }
        
        // 检查是否所有子单都满足条件：以节点为准，节点是结束节点则认为已完成
        return allSubFlows.stream().allMatch(subFlow -> {
            // 判断节点是否为结束节点（9999），节点是最准确的
            boolean isEndNode = ChangeFlowEnum.SUB_FLOW_END.getNodeId().equals(subFlow.getSubFlowNode());
            if (isEndNode) {
                // 节点是结束节点，认为已完成，允许流转
                // 如果状态不对，打印日志提醒
                Integer status = subFlow.getStatus();
                if (!ChangeSubFlowStatusEnum.FINISHED.getStatus().equals(status)
                        && !ChangeSubFlowStatusEnum.CANCELLED.getStatus().equals(status)) {
                    log.warn("[checkAllSubFlowsFinishedForMainFlow] 子单节点已是结束节点，但状态不正确，subFlowId:{}, status:{}, 期望状态:{}或{}",
                            subFlow.getSubFlowId(), status,
                            ChangeSubFlowStatusEnum.FINISHED.getStatus(),
                            ChangeSubFlowStatusEnum.CANCELLED.getStatus());
                }
                return true;
            }
            return false;
        });
    }

    /**
     * 发送子单完成/取消邮件
     * 
     * @param subFlowRecord 子单记录
     */
    private void sendSubFlowFinishEmail(ChangeSubFlowRecord subFlowRecord) {
        try {
            // 查询主单信息
            ChangeRecord mainRecord = changeRecordMapper.selectByPrimaryKey(subFlowRecord.getChangeRecordId());
            if (mainRecord == null) {
                log.warn("[sendSubFlowFinishEmail] 主单不存在，跳过发送邮件，changeRecordId:{}", subFlowRecord.getChangeRecordId());
                return;
            }
            
            // 收件人：变更负责人+所有变更行动人+变更管理QM
            String changeExecUserEmail = subFlowRecord.getChangeExecUserEmail();
            List<String> receiverList = Collections.singletonList(changeExecUserEmail);
            receiverList.add(mainRecord.getChangeCommander());
            receiverList.add(appConfig.getChangeManageQM());
            
            // 抄送人：所有变更行动人上一级LEADER+变更管理委员会
            List<String> ccList = departmentLeaderBiz.getDepartmentLeaders(Collections.singletonList(changeExecUserEmail));
            ccList.add(appConfig.getChangeCommittee());
            
            // 构建邮件主题：【已完结】变更主体+变更内容+工单ID-子单ID
            String subjectParam = ChangeSubjectEnum
                    .getChangeSubjectEnum(mainRecord.getChangeSubject()).getDesc()
                    + mainRecord.getChangeContent() + mainRecord.getFlowId() + "-" + subFlowRecord.getSubFlowId();
            
            // 构建邮件参数
            HashMap<String, Object> emailMap = new HashMap<>();
            emailMap.put("changeId", mainRecord.getFlowId() + "-" + subFlowRecord.getSubFlowId());
            emailMap.put("changeSubject", ChangeSubjectEnum.getChangeSubjectEnum(mainRecord.getChangeSubject()).getDesc());
            emailMap.put("flowUrl", mainRecord.getFlowId());
            
            // 发送邮件
            changeFlowBiz.qcSendEmail(receiverList, ccList, subjectParam, EmailTemplateEnum.YX_QC_CHANGE_FINISH, emailMap);
            
            // 如果是供应商，再次发送供应商邮件
            if (mainRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                sendSupplierEmail.sendSupplierEmail(mainRecord.getCreateSupplier(), subjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_FINISH, emailMap);
            }
            
            // 如果是其他端发起但是是供应商变更，再次发送供应商邮件
            if (!mainRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())
                    && ChangeSubjectEnum.SUPPLIER.getType().equals(mainRecord.getChangeSubject())) {
                sendSupplierEmail.sendSupplierEmail(mainRecord.getChangeSupplier(), subjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_FINISH, emailMap);
            }
            
            log.info("[sendSubFlowFinishEmail] 子单邮件发送成功，subFlowId:{}", subFlowRecord.getSubFlowId());
        } catch (Exception e) {
            log.error("[sendSubFlowFinishEmail] 子单邮件发送失败，subFlowId:{}", subFlowRecord.getSubFlowId(), e);
        }
    }

    /**
     * 根据变更行动工单ID查询详情
     * 说明：展示内容和主单的detail一样，但行动项只展示该变更行动工单下绑定的行动项
     *
     * @param subFlowId 变更行动工单ID（即topo）
     * @return 变更工单详情
     */
    public ChangeFlowVO detailBySubFlowId(String subFlowId) {
        log.info("[detailBySubFlowId] 查询变更行动工单详情，subFlowId:{}", subFlowId);
        if (StringUtils.isBlank(subFlowId)) {
            throw ExceptionFactory.createBiz(ResponseCode.ERROR_FLOW_ID, "变更行动工单ID不能为空");
        }

        // 根据 subFlowId 查询变更行动工单记录
        ChangeSubFlowRecord subFlowRecord = changeSubFlowRecordService.getBySubFlowId(subFlowId);
        if (subFlowRecord == null) {
            throw ExceptionFactory.createBiz(ResponseCode.ERROR_FLOW_ID, "变更行动工单不存在");
        }

        Long changeRecordId = subFlowRecord.getChangeRecordId();
        Long subFlowRecordId = subFlowRecord.getId();

        // 先根据 changeRecordId 查询主单，获取 flow_id
        ChangeRecord mainRecord = changeRecordMapper.selectByPrimaryKey(changeRecordId);
        if (mainRecord == null) {
            throw ExceptionFactory.createBiz(ResponseCode.ERROR_FLOW_ID, "主工单不存在");
        }
        
        // 调用主单的 detail 方法获取完整信息（传入 flow_id）
        ChangeFlowVO changeFlowVO = changeFlowBiz.detail(mainRecord.getFlowId());

        // topoId：这是子单详情页面，需要设置为子单的 topoId
        changeFlowVO.setTopoId(ChangeFlowEnum.CHANGE_SUB_FLOW.getTopoId());
        // flowNode：应该使用子单的数据，而不是主单的数据
        changeFlowVO.setFlowNode(subFlowRecord.getSubFlowNode());
        // mainFlowNode：设置主单的节点，用于前端判断是否允许提交执行结果
        changeFlowVO.setMainFlowNode(mainRecord.getFlowNode());
        
        // 子单特有字段：从子单记录中获取并设置到VO中
        changeFlowVO.setChangeResult(subFlowRecord.getChangeResult());
        changeFlowVO.setRemark(subFlowRecord.getRemark());
        changeFlowVO.setCancelReason(subFlowRecord.getCancelReason());
        changeFlowVO.setChangeConfirmResultTime(subFlowRecord.getChangeConfirmResultTime());
        
        // 查询子单的文件（替换主单的文件）
        List<ChangeSubFlowFile> subFlowFiles = changeSubFlowFileService.getFileList(subFlowRecordId);
        if (CollectionUtils.isNotEmpty(subFlowFiles)) {
            List<ChangeFlowFile> fileList = subFlowFiles.stream().map(f -> {
                ChangeFlowFile file = new ChangeFlowFile();
                file.setFileName(f.getFileName());
                file.setFileUrl(f.getFileUrl());
                file.setFileType(f.getFileType());
                return file;
            }).collect(Collectors.toList());
            changeFlowVO.setFiles(fileList);
        } else {
            changeFlowVO.setFiles(new ArrayList<>());
        }

        // 只保留该变更行动工单下绑定的行动项
        List<ChangeExecRecord> execRecords = changeFlowExecService.getBySubFlowRecordId(subFlowRecordId);
        if (CollectionUtils.isNotEmpty(execRecords)) {
            List<ChangeFlowExecVO> filteredExecList = execRecords.stream().map(c -> {
                ChangeFlowExecVO vo = new ChangeFlowExecVO();
                BeanUtils.copyProperties(c, vo);
                vo.setChangeExecId(c.getId());
                return vo;
            }).collect(Collectors.toList());

            // 填充用户名信息
            try {
                Set<String> userEmail = filteredExecList.stream().map(ChangeFlowExecVO::getChangeExecUserEmail)
                    .collect(Collectors.toSet());
                AjaxResponse<List<IusUserInfoRsp>> userListInfo = iusRpcService
                    .queryUserListInfo(UserQueryDTO.builder().uids(new ArrayList<>(userEmail)).build());
                List<IusUserInfoRsp> data = userListInfo.getData();
                filteredExecList.forEach(i -> {
                    Optional<IusUserInfoRsp> anyExeUser = data.stream()
                        .filter(u -> u.getUid().equals(i.getChangeExecUserEmail())).findAny();
                    if (anyExeUser.isPresent()) {
                        i.setChangeExecUserName(anyExeUser.get().getName());
                    } else {
                        // 批量查询没查到的人名，通过全量查询单独再查一次
                        IusUserInfoRsp user = iusService.queryUserInfo(i.getChangeExecUserEmail());
                        if (user != null && StringUtils.isNotBlank(user.getName())) {
                            i.setChangeExecUserName(user.getName());
                        }
                    }
                });
            } catch (Exception ex) {
                log.error("query user info has ex", ex);
            }

            changeFlowVO.setChangeExecProjectList(filteredExecList);
        } else {
            changeFlowVO.setChangeExecProjectList(new ArrayList<>());
        }

        return changeFlowVO;
    }

    /**
     * 查询变更行动工单列表
     *
     * @param page 页码
     * @param pageSize 每页大小
     * @param queryReq 查询条件
     * @return 变更行动工单列表
     */
    public ChangeSubFlowListVO querySubFlowList(Integer page, Integer pageSize, ChangeSubFlowListQueryReq queryReq) {
        log.info("[querySubFlowList] page:{}, pageSize:{}, queryReq:{}", page, pageSize, JSON.toJSONString(queryReq));

        String currentUser = RequestLocalBean.getUid();
        
        // 如果 onlyMyFollowed=true，设置 currentUser，用于在子单查询时过滤
        // 子单查询条件：change_exec_user_email = 当前用户 OR approver 包含当前用户 OR change_commander = 当前用户
        if (queryReq.getOnlyMyFollowed() && StringUtils.isNotBlank(currentUser)) {
            queryReq.setCurrentUser(currentUser);
        }
        
        // 根据主单条件（flowId, itemId, supplier）查询主单，获取 changeRecordIds
        if (queryReq.getFlowId() != null || StringUtils.isNotBlank(queryReq.getItemId())
                || StringUtils.isNotBlank(queryReq.getSupplier())) {
            List<Long> changeRecordIds = filterFlowRecordIds(queryReq);
            if (CollectionUtils.isEmpty(changeRecordIds)) {
                // 如果主单查询结果为空，直接返回
                PageVO pageVO = PageUtils.buildPageVo(0L, pageSize, page);
                ChangeSubFlowListVO result = new ChangeSubFlowListVO();
                result.setPageVo(pageVO);
                result.setChangeSubFlowList(new ArrayList<>());
                return result;
            }
            queryReq.setChangeRecordIds(changeRecordIds);
        }

        // 进行分页查询子单
        PageHelper.startPage(page, pageSize);
        List<ChangeSubFlowRecord> subFlowRecords = changeSubFlowRecordMapper.selectByCondition(queryReq);
        PageInfo<ChangeSubFlowRecord> subFlowRecordPageInfo = new PageInfo<>(subFlowRecords);

        // 第四步：批量获取主单信息和行动项信息，构建返回列表
        List<ChangeSubFlowVO> list = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(subFlowRecords)) {
            // 批量获取主单信息
            List<Long> changeRecordIds = subFlowRecords.stream().map(ChangeSubFlowRecord::getChangeRecordId).distinct()
                .collect(Collectors.toList());
            final Map<Long, ChangeRecord> changeRecordMap;
            if (CollectionUtils.isNotEmpty(changeRecordIds)) {
                List<ChangeRecord> changeRecords = changeFlowService.getByIds(changeRecordIds);
                changeRecordMap = changeRecords.stream().filter(Objects::nonNull)
                    .collect(Collectors.toMap(ChangeRecord::getId, r -> r));
            } else {
                changeRecordMap = new HashMap<>();
            }

            // 批量获取行动项信息（用于获取行动人、部门、完成时间等）
            List<Long> subFlowRecordIds = subFlowRecords.stream().map(ChangeSubFlowRecord::getId)
                .collect(Collectors.toList());
            Map<Long, List<ChangeExecRecord>> execRecordMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(subFlowRecordIds)) {
                List<ChangeExecRecord> allExecRecords = changeFlowExecService.getBySubFlowRecordIds(subFlowRecordIds);
                if (CollectionUtils.isNotEmpty(allExecRecords)) {
                    execRecordMap = allExecRecords.stream().filter(exec -> exec.getSubFlowRecordId() != null)
                        .collect(Collectors.groupingBy(ChangeExecRecord::getSubFlowRecordId));
                }
            }

            // 构建返回列表
            for (ChangeSubFlowRecord subFlowRecord: subFlowRecords) {
                ChangeSubFlowVO vo = new ChangeSubFlowVO();
                vo.setSubFlowId(subFlowRecord.getSubFlowId());
                vo.setStatus(subFlowRecord.getStatus());
                vo.setStatusDesc(ChangeSubFlowStatusEnum.getDescByStatus(subFlowRecord.getStatus()));
                vo.setCreateTime(subFlowRecord.getCreateTime());

                // 获取主单信息
                ChangeRecord changeRecord = changeRecordMap.get(subFlowRecord.getChangeRecordId());
                if (changeRecord != null) {
                    vo.setFlowId(changeRecord.getFlowId());
                }

                // 获取行动项信息（取第一个行动项的信息作为展示）
                List<ChangeExecRecord> execRecords = execRecordMap.get(subFlowRecord.getId());
                if (CollectionUtils.isNotEmpty(execRecords)) {
                    ChangeExecRecord firstExec = execRecords.get(0);
                    vo.setChangeExecUserEmail(firstExec.getChangeExecUserEmail());
                    vo.setChangeExecDepartment(firstExec.getChangeExecDepartment());
                    // 完成时间：如果有完成时间则使用，否则使用预期完成时间（从主单获取）
                    if (firstExec.getChangeExecFinishTime() != null) {
                        vo.setChangeExecFinishTime(firstExec.getChangeExecFinishTime());
                    } else if (changeRecord != null) {
                        vo.setChangeExecFinishTime(changeRecord.getChangeConfirmResultTime());
                    }
                }

                // 设置子单归属关系
                if (StringUtils.isNotBlank(currentUser)) {
                    // 是否是执行人（change_exec_user_email）
                    boolean isExecutor = currentUser.equals(subFlowRecord.getChangeExecUserEmail());
                    
                    // 是否是审批人（approver）
                    boolean isApprover = false;
                    String subApproverJson = subFlowRecord.getApprover();
                    if (StringUtils.isNotBlank(subApproverJson)) {
                        isApprover = subApproverJson.contains(currentUser);
                    }
                    
                    // 是否是主单变更负责人（change_commander，关联主单的负责人）
                    boolean isMainFlowCommander = currentUser.equals(subFlowRecord.getChangeCommander());
                    
                    ChangeSubFlowOwnershipVO flowOwnership = ChangeSubFlowOwnershipVO.builder()
                            .isExecutor(isExecutor)
                            .isApprover(isApprover)
                            .isMainFlowCommander(isMainFlowCommander)
                            .build();
                    vo.setFlowOwnership(flowOwnership);
                }

                list.add(vo);
            }

            // 批量查询用户名信息
            try {
                Set<String> userEmails = list.stream().map(ChangeSubFlowVO::getChangeExecUserEmail)
                    .filter(StringUtils::isNotBlank).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(userEmails)) {
                    AjaxResponse<List<IusUserInfoRsp>> userListInfo = iusRpcService
                        .queryUserListInfo(UserQueryDTO.builder().uids(new ArrayList<>(userEmails)).build());
                    List<IusUserInfoRsp> userData = userListInfo.getData();
                    Map<String, String> userNameMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(userData)) {
                        userNameMap = userData.stream()
                            .collect(Collectors.toMap(IusUserInfoRsp::getUid, IusUserInfoRsp::getName));
                    }

                    // 填充用户名和展示信息
                    for (ChangeSubFlowVO vo: list) {
                        String email = vo.getChangeExecUserEmail();
                        if (StringUtils.isNotBlank(email)) {
                            String name = userNameMap.get(email);
                            if (StringUtils.isBlank(name)) {
                                // 批量查询没查到的人名，通过全量查询单独再查一次
                                IusUserInfoRsp user = iusService.queryUserInfo(email);
                                if (user != null && StringUtils.isNotBlank(user.getName())) {
                                    name = user.getName();
                                }
                            }
                            vo.setChangeExecUserName(name);
                            // 构建展示信息：姓名+邮箱
                            if (StringUtils.isNotBlank(name)) {
                                vo.setChangeExecUserView(name + "(" + email + ")");
                            } else {
                                vo.setChangeExecUserView(email);
                            }
                        }
                    }
                }
            } catch (Exception ex) {
                log.error("query user info has ex", ex);
            }
        }

        PageVO pageVO = PageUtils.buildPageVo(subFlowRecordPageInfo.getTotal(), pageSize, page);
        ChangeSubFlowListVO result = new ChangeSubFlowListVO();
        result.setPageVo(pageVO);
        result.setChangeSubFlowList(list);
        return result;
    }

    /**
     * 根据主单条件查询主单记录ID列表
     *
     * @param queryReq 查询条件
     * @return 主单记录ID列表
     */
    private List<Long> filterFlowRecordIds(ChangeSubFlowListQueryReq queryReq) {
        ChangeFlowListQueryReq mainQueryReq = new ChangeFlowListQueryReq();
        mainQueryReq.setFlowId(queryReq.getFlowId());
        mainQueryReq.setItemId(queryReq.getItemId());
        mainQueryReq.setSupplier(queryReq.getSupplier());

        // 查询主单（不分页，只获取ID）
        List<ChangeRecord> changeRecords = changeRecordMapper.selectByCondition(mainQueryReq);

        if (CollectionUtils.isEmpty(changeRecords)) {
            return new ArrayList<>();
        }

        return changeRecords.stream().map(ChangeRecord::getId).distinct().collect(Collectors.toList());
    }

}
