package com.netease.mail.yanxuan.change.biz.meta.exception;


import com.netease.mail.yanxuan.change.common.bean.ResponseCode;

/**
 * @author: bndong
 * @date: 2021/5/25
 */
public class ServiceException extends RuntimeException {

    private static final long serialVersionUID = 2531549421457088715L;
    private ResponseCode code = ResponseCode.SUCCESS;

    private String msg;

    public ServiceException(ResponseCode code, String msg) {
        super("code:" + code + ",msg:" + msg);
        this.msg = msg;
        this.code = code;
    }

    public ServiceException(ResponseCode code) {
        super("code:" + code.getCode() + ",msg:" + code.getMsg());
        this.code = code;
        this.msg = code.getMsg();
    }


    public ResponseCode getCode() {
        return code;
    }

    public int getIntCode() {
        return code.getCode();
    }

    public void setCode(ResponseCode code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
