package com.netease.mail.yanxuan.change.dal.config;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author hzfengyuexin@corp.netease.com
 */
@Data
@Component
@EnableAutoUpdateApolloConfig("db-public")
public class DrmDBConfig {

    @ApolloConfig("db-public")
    private Config config;

    @Value("${db.url:}")
    private String url;

    @Value("${db.username:}")
    private String userName;

    @Value("${db.password:}")
    private String password;

    @Value("${db.driverClassName:}")
    private String driverClassName;
}
