package com.netease.mail.yanxuan.change.integration.email.service;

import com.netease.mail.yanxuan.change.integration.email.email.EmailFactor;
import java.io.File;
import java.util.Collection;
import java.util.List;

/**
 * 发送邮件
 */
public interface IEmailService {

    /**
     * @param to 收件人
     * @param emailFactor 邮件要素
     */
    void sendEmail(String to, EmailFactor emailFactor);

    /**
     * @param toList 收件人列表
     * @param factor 要素
     */
    void sendEmail(Collection<String> toList, EmailFactor factor);

    /**
     * @param toList 收件人
     * @param ccList 抄送人
     * @param factor 要素
     * @param fileList 附件
     */
    void sendEmail(String toList, String ccList, EmailFactor factor,List<File> fileList);

    /**
     *
     * @param toList 收件人列表
     * @param ccList 抄送人列表
     * @param factor 要素
     */
    void sendEmail(Collection<String> toList, Collection<String> ccList, EmailFactor factor);

    /**
     * @param toList 收件人列表
     * @param ccList 抄送人列表
     * @param factor 要素
     * @param fileList 附件
     */
    void sendEmail(Collection<String> toList, Collection<String> ccList, EmailFactor factor, List<File> fileList);


}
