/**
 * 变更行动工单状态枚举
 *
 * @Author system
 * @Date 2024/01/01
 */
package com.netease.mail.yanxuan.change.common.enums;

import lombok.Getter;

/**
 * 变更行动工单状态枚举
 */
@Getter
public enum ChangeSubFlowStatusEnum {
    /**
     * 待确认行动方案
     */
    WAIT_CONFIRM_ACTION_PLAN(1, "待确认行动方案"),
    
    /**
     * 待审批行动方案
     */
    WAIT_APPROVE_ACTION_PLAN(2, "待审批行动方案"),
    
    /**
     * 待审批变更方案
     */
    WAIT_APPROVE_CHANGE_PLAN(3, "待审批变更方案"),
    
    /**
     * 待提交执行结果
     */
    WAIT_SUBMIT_RESULT(4, "待提交执行结果"),
    
    /**
     * 已完结
     */
    FINISHED(5, "已完结"),
    
    /**
     * 已取消
     */
    CANCELLED(6, "已取消");

    private final Integer status;
    private final String desc;

    ChangeSubFlowStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    /**
     * 根据状态值获取枚举
     */
    public static ChangeSubFlowStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        for (ChangeSubFlowStatusEnum statusEnum : values()) {
            if (statusEnum.getStatus().equals(status)) {
                return statusEnum;
            }
        }
        return null;
    }

    /**
     * 根据状态值获取描述
     */
    public static String getDescByStatus(Integer status) {
        ChangeSubFlowStatusEnum statusEnum = getByStatus(status);
        return statusEnum != null ? statusEnum.getDesc() : null;
    }
}

