/**
 * @(#)ChangeFlowServiceImpl.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.config.TitleConfig;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeRecordMapper;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Service
public class ChangeFlowServiceImpl implements ChangeFlowService {

    @Autowired
    private ChangeRecordMapper changeRecordMapper;

    @Autowired
    private AppConfig appConfig;

    @Override
    public TitleConfig getTitleConfig() {
        return appConfig.getTitleConfig();
    }

    @Override
    public Boolean saveRecord(ChangeRecord changeRecord) {
        return changeRecordMapper.insertSelective(changeRecord) > 0;
    }

    @Override
    public ChangeRecord getByFlowId(Long flowId) {
        return changeRecordMapper.selectByFlowId(flowId);
    }

    @Override
    public Boolean updateRecord(ChangeRecord changeRecord) {
        return changeRecordMapper.updateByPrimaryKeySelective(changeRecord) > 0;
    }

    @Override
    public ChangeRecord getById(Long id) {
        return changeRecordMapper.selectByPrimaryKey(id);
    }
}