package com.netease.mail.yanxuan.change.integration.flow.supplier.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierInfoService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import com.netease.mail.yanxuan.change.integration.rpc.RpcObjectHandler;
import com.netease.mail.yanxuan.change.integration.rpc.RpcTemplate;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/12/8/008$
 */
@Service
public class FlowRpcSupplierInfoServiceImpl implements FlowRpcSupplierInfoService {

    @Autowired
    private RpcTemplate rpcTemplate;

    Logger logger = LoggerFactory.getLogger(FlowRpcSupplierInfoServiceImpl.class);

    @Override
    public List<SupplierUserRsp> querySupplierRelatedUser(SupplierRelatedUserReq req) {
        String url = "http://127.0.0.1:8550/proxy/test-v1.yanxuan-supplier-ms.service.mailsaas/api/supplier/batchGetSupplierRelatedUser.json";
        JSONObject supplierUserRsp = rpcTemplate.postJson(url, JSON.toJSONString(req),500,new RpcObjectHandler<>(JSONObject.class));
        Object data = supplierUserRsp.get("data");
        List<SupplierUserRsp> objects = JSONArray.parseArray(data.toString(), SupplierUserRsp.class);
        logger.error("请求返回结果"+objects);
        return objects;
    }
}
