/**
 * @(#)IusService.java, 2022/12/7.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.integration.flow.UserQueryDTO;
import com.netease.mail.yanxuan.change.integration.flow.ius.IusRpcService;
import com.netease.mail.yanxuan.change.integration.flow.ius.req.IusDepartmentReq;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.IusUserInfoRsp;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.SecondaryDepartments;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/12/7
 */
@Slf4j
@Component
public class IusService {
    @Autowired
    private IusRpcService iusRpcService;

    public HashMap<String, List<SecondaryDepartments>> queryDepartment(IusDepartmentReq iusDepartmentReq) {
        log.info("[queryDepartment] queryDepartment req:{}", JSON.toJSONString(iusDepartmentReq));
        AjaxResponse<HashMap<String, List<SecondaryDepartments>>> response = iusRpcService.queryDepartment(iusDepartmentReq);
        log.info("[queryDepartment] response of queryDepartment ={}",
                JSON.toJSONString(response));
        if (ResponseCodeEnum.SUCCESS.getCode() == response.getCode()) {
            return response.getData();
        } else {
            log.error("[queryDepartment] queryDepartment failed, query={}, errMsg={}", JSON.toJSONString(iusDepartmentReq),
                    JSON.toJSONString(response));
            throw ExceptionFactory.createBiz(ResponseCode.CREATE_FLOW_ERROR, "查询部门错误");
        }
    }

    /**
     * 查询用户信息
     */
    public List<IusUserInfoRsp> queryUserListInfo(UserQueryDTO query) {
        log.info("[queryUserListInfo] queryUserListInfo req:{}", JSON.toJSONString(query));
        AjaxResponse<List<IusUserInfoRsp>> response = iusRpcService.queryUserListInfo(query);
        log.info("[queryUserListInfo] response of queryUserListInfo ={}", JSON.toJSONString(response));
        if (ResponseCodeEnum.SUCCESS.getCode() == response.getCode()) {
            return response.getData();
        } else {
            log.error("[queryUserListInfo] queryUserListInfo failed, query={}, errMsg={}", JSON.toJSONString(query),
                JSON.toJSONString(response));
            return new ArrayList<>();
        }
    }

    /**
     * 根据邮箱查询单个用户信息
     */
    public IusUserInfoRsp queryUserInfo(String uid) {
        log.info("[queryUserInfo] queryUserInfo req:{}", uid);
        // icac==true未全局查询，需保证必须查到用户名
        AjaxResponse<IusUserInfoRsp> response = iusRpcService.queryUserInfo(uid, true);
        log.info("[queryUserInfo] response of queryUserInfo ={}", JSON.toJSONString(response));
        if (ResponseCodeEnum.SUCCESS.getCode() == response.getCode()) {
            return response.getData();
        } else {
            log.error("[queryUserInfo] queryUserInfo failed, query={}, errMsg={}", uid, JSON.toJSONString(response));
            return null;
        }
    }
}