/**
 * @(#)MainSpuStatusEmum.java, 2022/12/20.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

/**
 * @Author zcwang
 * @Date 2022/12/20
 */
public enum MainSpuStatusEnum {
    INIT(0,"未上架"),
    NOT_ON_SHELVES(1,"未上架"),
    ON_SHELVES(2,"已上架"),
    PRESHELVING(4,"预上架");

    private Integer status;

    private String desc;

    MainSpuStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByStatus(Integer status) {
        for (MainSpuStatusEnum value : MainSpuStatusEnum.values()) {
            if (value.getStatus().equals(status)) {
                return value.getDesc();
            }
        }
        return "";
    }
}