/**
 * @(#)ProfitTypeEnum.java, 2022/12/2.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

/**
 * @Author zcwang
 * @Date 2022/12/2
 */
public enum ProfitTypeEnum {
    RISK_CONTROL(1, "风险控制类"),
    REDUCE_COST(2, "降本类"),
    PRODUCT_IMPROVE(3, "商品改善类"),
    REPLACE_CERTIFICATES_WHEN_EXPIRE(4, "证件到期更换"),
    OTHER(5, "其他"),
    NO(6, "无");

    private Integer type;

    private String desc;

    ProfitTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getByType(Integer type) {
        for (ProfitTypeEnum value : ProfitTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value.getDesc();
            }
        }
        return "";
    }
}