package com.netease.mail.yanxuan.change.web.config;


import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yx.openid.YxOpenidLogin;
import com.netease.mail.yx.openid.YxOpenidUser;

import lombok.extern.slf4j.Slf4j;

/**
 * 提取用户uid
 *
 * @author lwtang
 */
@Component
@Slf4j
public class UserInterceptor implements HandlerInterceptor {


    @Value("${product:product}")
    String product;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
                             Object handler) throws Exception {
        //获取cookie信息
        Cookie[] cookies = request.getCookies();
        String userCookie = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals("YX_OPENID_SESS")) {
                    userCookie = cookie.getValue();
                }
            }
        }

        log.info("YX_OPENID_SESS: {}", userCookie);
        // 解析cookie
        YxOpenidUser yxuser = null;
        if (userCookie != null) {
            yxuser = YxOpenidLogin.parseCookie(userCookie);
        }

        // ajax请求，走返回码
        String accept = request.getHeader("Accept");

        // cookie不存在或者超过一个小时(时间自己定)
        if (yxuser == null || yxuser.getLoginTime() < System.currentTimeMillis() - 60 * 1000 * 1000) {
            //如果是ajax请求
            if (!accept.contains("text/html")
                    || request.getRequestURI().contains("ajax")) {
                log.info("ajax request user is null or login time too early, yxuser: {}", yxuser);
            } else {
                String url = request.getRequestURL().toString();
                String loginUrl = YxOpenidLogin.getLoginUrl(url);
                log.info("redirect url: {}", loginUrl);
                response.sendRedirect(loginUrl);
            }
        } else {
            // 获取用户信息
            // 邮箱地址
            String email = yxuser.getEmail();
            RequestLocalBean.setUid(email);
            // 中文姓名
            String fullname = yxuser.getFullName();
            RequestLocalBean.setName(fullname);
            // 用户登录时间戳
            long loginTime = yxuser.getLoginTime();
            log.info("[UserAccess] user: {}, url: {}", email, request.getPathInfo());
            RequestLocalBean.setLastLoginTime(loginTime);
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response,
                                Object handler, Exception ex) throws Exception {
        RequestLocalBean.clear();
    }
}
