package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.netease.mail.yanxuan.change.integration.email.email.EmailFactor;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTypeEnum;
import com.netease.mail.yanxuan.change.integration.email.service.IEmailService;
import com.netease.mail.yanxuan.change.integration.email.service.UasClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class EmailServiceImpl implements IEmailService {

    @Autowired
    private UasClientService uasClient;

    @Autowired
    private EmailTemplateServiceImpl emailTemplateService;

    @Override
    @Async("asyncEmail")
    public void sendEmail(Collection<String> toList, Collection<String> ccList,
                            HashMap<String,Object> map, EmailTemplateEnum emailTemplateEnum, List<String>subjectParams) {
        EmailFactor emailFactor = new EmailFactor();
        //固定
        emailFactor.setType(EmailTypeEnum.TEXT.getType());
        emailFactor.setEmailTemplateEnum(emailTemplateEnum);
        emailFactor.setData(map);
        if (map != null) {
            String content = this.content(emailFactor);
            if (!CollectionUtils.isEmpty(toList)) {
                toList = toList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(ccList)) {
                ccList = ccList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            String subject = emailFactor.getSubject();
            //标题参数处理
            if (subjectParams != null){
                subject = String.format(subject,subjectParams.toArray());
            }
            uasClient.sendEmail(subject, content, toList, ccList, null);
        }
    }


    /**
     * 根据邮件模版获取邮件内容
     *
     * @param emailFactor
     * @return
     */

    public String content(EmailFactor emailFactor) {
        EmailTemplateEnum emailTemplateEnum = emailFactor.getEmailTemplateEnum();
        return emailTemplateService.template(emailTemplateEnum.getCode(), emailFactor.getData(),
                emailFactor.getType());
    }

}

