/**
 * @(#)SupplierService.java, 2022/12/15.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/12/15
 */
@Component
@Slf4j
public class SupplierService {

    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    public List<SupplierSimpleRsp> getSupplierName(String supplierUid) {
        log.info("[getSupplierName] request of query={}", supplierUid);
        AjaxResult<List<SupplierSimpleRsp>> response = supplierSendService.queryByConditionForQc(
                SupplierSearchRemoteReq.builder().limitSupplierIdList(Collections.singletonList(supplierUid)).build());
        log.info("[getSupplierName] response of query={}", JSON.toJSONString(response));
        if (Boolean.TRUE.equals(response.isSuccess())) {
            return response.getData();
        }
        log.error("[op:getSupplierName] getSupplierName failed, query={}, errMsg={}", supplierUid,
                response.getMsg());
        return Collections.emptyList();
    }
}