/**
 * @(#)ChangeFlowExcelVo.java, 2022/12/8.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.excel;

import java.util.ArrayList;
import java.util.List;

import com.netease.mail.dp.des.common.api.enums.ExcelCellType;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.yanxuan.change.common.anno.ExcelTitleName;
import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/12/8
 */
@Data
public class ChangeFlowExcelVo {
    /**
     * 变更id
     */
    @ExcelTitleName(title = "变更id", order = 1)
    private Long flowId;

    /**
     * 变更发起时间
     */
    @ExcelTitleName(title = "变更发起时间", order = 2)
    private String createTime;

    /**
     * 变更发起人
     */
    @ExcelTitleName(title = "变更发起人", order = 3)
    private String changeCreator;

    /**
     * 变更主体
     * @see ChangeSubjectEnum
     */
    @ExcelTitleName(title = "变更主体", order = 4)
    private String changeSubject;

    /**
     * 变更类型，一级类型>二级类型
     */
    @ExcelTitleName(title = "变更类型", order = 5)
    private String changeType;

    /**
     * 变更等级
     */
    @ExcelTitleName(title = "变更等级", order = 6)
    private String changeLevel;

    /**
     * 变更负责部门名
     */
    @ExcelTitleName(title = "变更负责部门名", order = 7)
    private String changeDepartment;

    /**
     * 变更负责人
     */
    @ExcelTitleName(title = "变更负责人", order = 8)
    private String changeCommander;
    /**
     * 变更供应商：供应商ID+供应商名称
     */
    @ExcelTitleName(title = "变更供应商", order = 9)
    private String supplier;

    /**
     * 变更原因
     */
    @ExcelTitleName(title = "变更原因", order = 10)
    private String changeReason;

    /**
     * 变更内容
     */
    @ExcelTitleName(title = "变更内容", order = 11)
    private String changeContent;

    /**
     * 变更潜在风险描述
     */
    @ExcelTitleName(title = "变更潜在风险描述", order = 12)
    private String changeRiskDesc;

    /**
     * 变更收益类型
     */
    @ExcelTitleName(title = "变更收益类型", order = 13)
    private Integer changeProfit;

    /**
     * 变更收益说明
     */
    @ExcelTitleName(title = "变更收益说明", order = 14)
    private String changeProfitDesc;

    /**
     * 变更商品,商品名称
     */
    @ExcelTitleName(title = "变更商品", order = 15)
    private String changeItem;

    /**
     * SPUID
     */
    @ExcelTitleName(title = "SPUID", order = 16)
    private String SPUId;

    /**
     * 品控类目
     */
    @ExcelTitleName(title = "品控类目", order = 17)
    private String qcCategory;

    /**
     * 物理类目
     */
    @ExcelTitleName(title = "物理类目", order = 18)
    private String phyCategory;

    /**
     * 商品立项类型，0-正常立项商品，2-特殊免立项商品 3-组合装
     */
    @ExcelTitleName(title = "商品立项类型", order = 19)
    private Integer itemSetupType;

    /**
     * 经营形式，0-自营，3-严选贴牌代销，4-他方品牌代销，5-代销2.0
     */
    @ExcelTitleName(title = "经营形式", order = 20)
    private Integer businessForm;
    /**
     * 商品状态，0-未上架，1-未上架，2-已上架，4-预上架
     */
    @ExcelTitleName(title = "商品状态", order = 21)
    private String status;

    /**
     * 商品负责人
     */
    @ExcelTitleName(title = "商品负责人", order = 22)
    private String functionary;

    /**
     * 采购负责人
     */
    @ExcelTitleName(title = "采购负责人", order = 23)
    private String purchase;

    /**
     * SQE负责人
     */
    @ExcelTitleName(title = "SQE负责人", order = 24)
    private String goodsSqe;
    /**
     * 计划负责人
     */
    @ExcelTitleName(title = "计划负责人", order = 25)
    private String goodsProjectName;

    /**
     * 变更行动部门
     */
    @ExcelTitleName(title = "变更行动部门", order = 26)
    private String execDepartment;

    /**
     * 变更行动人
     */
    @ExcelTitleName(title = "变更行动人", order = 27)
    private String changeExecUser;

    /**
     * 变更状态
     * @see ChangeStatusEnum
     */
    @ExcelTitleName(title = "变更状态", order = 9)
    private Integer changeState;


    public static List<ExcelCell> init(ChangeFlowExcelDTO dto) {
        List<ExcelCell> cellInfo = new ArrayList<>();
        ExcelCell excelCell = new ExcelCell();
        excelCell.setCellType(ExcelCellType.TEXT);
        // id
        excelCell.setValue(dto.getId());
        cellInfo.add(excelCell);
        // 变更主体
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeSubject());
        cellInfo.add(excelCell);
        // 变更类型
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeType());
        cellInfo.add(excelCell);
        // 变更负责部门名
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeDepartment());
        cellInfo.add(excelCell);
        // 变更内容
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeContent());
        cellInfo.add(excelCell);
        // 变更负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCommander());
        cellInfo.add(excelCell);
        // 变更商品列表
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeItems());
        cellInfo.add(excelCell);
        // 变更供应商
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getSupplier());
        cellInfo.add(excelCell);
        // 变更状态
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeState());
        cellInfo.add(excelCell);
        // 变更发起人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCreator());
        cellInfo.add(excelCell);
        // 变更行动部门列表
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getExecDepartmentStrList());
        cellInfo.add(excelCell);
        // 创建时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getCreateTime());
        cellInfo.add(excelCell);

        return cellInfo;
    }
}