package com.netease.mail.yanxuan.change.biz.service.change;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeTypePo;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 * 基础服务用来方便内部调用
 */
public interface ChangeTypeService {

    /**
     * 查询变更类型表
     * @param id id
     * @Param sonChangeClassId 二级ID
     * @param deleteTab  是否查伪删除数据
     * @return
     */
    List<ChangeType> queryChangeType(Long id,Long sonChangeClassId,Boolean deleteTab);

    /**
     * 添加类型 如果遇到内容一样的情况下不能覆盖直接修改伪删状态  涉及到二级关联信息
     * 关系是一对一绑定的所以List里面只会存储两条对象
     * @param changeTypes
     * @return
     */
    List<ChangeType> addChangeType(List<ChangeType> changeTypes);

    /**
     * 因为牵扯到历史变更查询未保证变更类型的持久性不做真实删除和修改
     * 伪善原来的 后新增
     * @param changeTypes
     * @return
     */
    List<ChangeType> updateChangeType(List<ChangeType> changeTypes);

    Boolean deleteChangeTypes(List<ChangeType> changeTypes);

    /**
     * 一级ID 二级ID 是否存在
     */
    /**
     * 二级目录类型查询出所有一级二级
     * @return
     */
    List<ChangeTypePo> queryConfigType();

    /**
     * 根据主键获取类型信息
     * @param id
     * @return
     */
    ChangeType getChangeTypeById(Long id);
}
