/**
 * @(#)DlockConfig.java, 2018/9/7.
 * <p/>
 * Copyright 2018 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.config;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author hzcaitianyu (hzcaitianyu@corp.netease.com)
 */
@Component
@EnableAutoUpdateApolloConfig("db-redis")
@Data
public class DrmRedisConfig {

    @ApolloConfig("db-redis")
    private Config config;

    @Value("${redis.master:}")
    private String master;

    @Value("${redis.nodes:}")
    private String nodes;

    @Value("${redis.password:}")
    private String password;

    @Value("${redis.maxTotal:50}")
    private Integer maxTotal;

    @Value("${redis.maxIdle:20}")
    private Integer maxIdle;

    @Value("${redis.maxWaitMillis:10000}")
    private Integer maxWaitMillis;

}