/**
 * @(#)TestController.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowService;
import com.netease.mail.yanxuan.change.biz.service.rpc.TodoService;
import com.netease.mail.yanxuan.change.biz.task.AutoSubmit;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.enums.ChangeFlowEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierGoodsInfoReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierRelatedUserReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierGoodsInfoRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierInfoRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierUserRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private TodoService todoService;

    @Autowired
    private ChangeFlowService changeFlowService;

    @Autowired
    private AutoSubmit autoSubmit;

    @PostMapping("/createToDo")
    public AjaxResult<Void> createTodoTask(ChangeRecord entity) {
        log.info("[createToDoTask] entity:{}", JSON.toJSONString(entity));
        todoService.createTodoTask(entity);
        return AjaxResult.success();
    }

    @PostMapping("/progressTodo")
    public AjaxResult<Void> progressTodoTask(ChangeRecord entity, Integer operateType) {
        log.info("[createToDoTask] entity:{}, operateType:{}", JSON.toJSONString(entity), operateType);
        todoService.progressTodoTask(entity, operateType);
        return AjaxResult.success();
    }

    @Autowired
    private FlowRpcSupplierSendService supplierSendService;

    @PostMapping("/test1")
    public String test1(@RequestBody List<Long> itemIds) {
        return supplierSendService.queryGoodsPurchase(itemIds);
    }
    private FlowRpcSupplierService rpcSupplierService;

    @PostMapping("/test2")
    public AjaxResponse<List<SupplierUserRsp>> test2(@RequestBody SupplierRelatedUserReq req) {
        return supplierSendService.querySupplierRelatedUser(req);
    @GetMapping("/test1")
    public AjaxResponse<List<SupplierInfoRsp>>  test1(@RequestParam(name = "fuzzySearchText") String fuzzySearchText){
        return rpcSupplierService.getSupplierInfo("aa","wb.mulongfei@mesg.corp.netease.com",fuzzySearchText);
    }

    @PostMapping("/test3")
    public AjaxResponse<List<SupplierSimpleRsp>> test3(@RequestBody SupplierSearchRemoteReq req) {
        return supplierSendService.queryByConditionForQc(req);
    }

    @PostMapping("/test4")
    public AjaxResponse<List<SupplierGoodsInfoRsp>> test4(@RequestBody SupplierGoodsInfoReq req) {
        return supplierSendService.SupplierGoodsInfoBySupplier(req);
    }

    @PostMapping("/submit")
    public AjaxResult<Void> submit(Long id) {
        ChangeRecord record = changeFlowService.getById(id);
        Assert.notNull(record, "工单不存在");
        if (!record.getFlowNode().equals(ChangeFlowEnum.CHANGE_FLOW_EXE.getNodeId())) {
            throw ExceptionFactory.createBiz(ResponseCode.SUBMIT_FLOW_ERROR, "不是变更执行节点，不可运维提交");
        }
        autoSubmit.progressRecord(record);
        return AjaxResult.success();
    }
}