/**
 * @(#)ChangeFlowReq.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Data
public class ChangeFlowSubmitReq {

    /**
     * 工单id
     */
    @NotNull(message = "工单id不能为空")
    private Long flowId;

    /**
     * 当前节点id
     */
    @NotBlank(message = "当前节点不能为空")
    private String currentNodeId;

    /**
     * 一级类型id
     */
    private Long parentChangeClassId;
    /**
     * 二级类型id
     */
    private Long sonChangeClassId;
    /**
     * 变更商品
     */
    private String changeItems;

    /**
     * 变更sku信息
     */
    private String changeSkus;

    /**
     * 变更供应商
     */
    private String changeSupplier;
    /**
     * 变更原因
     */
    private String changeReason;
    /**
     * 变更内容
     */
    private String changeContent;

    /**
     * 变更前后图片/视频
     */
    private List<ChangeFlowFile> changeFiles;

    /**
     * 资料上传
     */
    private List<ChangeFlowFile> uploadFiles;

    /**
     * 变更管理及行动项结果相关的资料文件
     */
    private List<ChangeFlowFile> changeResultFiles;

    /**
     * 变更潜在风险
     */
    private String changeRiskDesc;
    /**
     * 变更验证措施
     */
    private String changeChecking;
    /**
     * 变更收益类型
     */
    private Integer changeProfit;
    /**
     * 变更收益说明
     */
    private String changeProfitDesc;
    /**
     * 变更结果确认时间，时间戳
     */
    private Long changeConfirmResultTime;
    /**
     * 变更行动项
     */
    private List<ChangeExecConfigReq> changeExecProjectList;
    /**
     * 变更结论
     */
    private Integer changeResult;
    /**
     * 取消原因说明（取消时存在）
     */
    private String cancelReason;
    /**
     * 备注
     */
    private String remark;

    /**
     * 变更收益金额
     */
    private String changeProfitAmount;
    
    /**
     * 审批结果（审批节点使用：true-通过，false-不通过）
     */
    private Boolean approved;
    
    /**
     * 拒绝原因（审批不通过时必填）
     */
    private String rejectReason;
    
    /**
     * 要取消的子单ID列表（审批不通过时，选择要取消的行动工单）
     */
    private List<String> cancelSubFlowIds;
}