package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.mail.yanxuan.change.integration.email.service.UasClientService;
import com.netease.mail.yanxuan.change.integration.flow.email.EmailRpcService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author WangJiaXiang
 * @date 2022/11/28/028$
 */
@Service
public class UasClientServiceImpl implements UasClientService {

    Logger logger = LoggerFactory.getLogger(UasClientServiceImpl.class);

    @Autowired
    private EmailRpcService service;
    /*
    *
    * emailPath=/push/email/
    * rpcConfig.getUasApi()=http://127.0.0.1:8550/proxy/online.logistics-uas.service.mailsaas
    * UPLOAD_FILE  /push/email/attach/{0}/upload.json
    */

    public void sendEmail(String subject, String content, Collection<String> toList, Collection<String> ccList, List<File> fileList) {
        if (!CollectionUtils.isEmpty(toList)) {
            //String url = MessageFormat.format("http://{0}{1}/{2}", this.thirdPartyDrmConfig.getUasHostInner(), "/push/email/", this.thirdPartyDrmConfig.getUasProduct());
            Map<String, String> params = new HashMap();
            params.put("subject", subject);
            params.put("content", content);
            params.put("to", StringUtils.join(toList, ","));
            params.put("topic", "qc");
            if (!CollectionUtils.isEmpty(ccList)) {
                params.put("cc", StringUtils.join(ccList, ","));
            }
            String res = service.sendEmail(params);
            this.logger.info("返回信息日志打印\n"+res);
            this.logger.info("[op:sendEmail] res={} ", new Object[]{res});
            JSONObject jsonObject = JSON.parseObject(res);
            if (jsonObject.getInteger("code") != 200) {
                this.logger.error("SendEmail", (String)null, "send email failed, subject={},toList={},ccList={}", new Object[]{subject, JSON.toJSONString(toList), JSON.toJSONString(ccList)});
            }

        }
    }


}
