/**
 * @(#)ItemBasicInfoVO.java, 2022/11/30.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeGoodsPrincipalPO;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/30
 */
@Data
public class ItemBasicInfoVO {

    /**
     * 商品id
     */
    private Long itemId;

    /**
     * 商品名
     */
    private String itemName;

    /**
     * 品控类目
     */
    private String qcCategory;

    /**
     * 物理类目
     */
    private List<CategoryInfoVO> phyCategory;

    /**
     * 商品立项类型，0-正常立项商品，2-特殊免立项商品 3-组合装
     */
    private Integer itemSetupType;

    /**
     * 经营形式，0-自营，3-严选贴牌代销，4-他方品牌代销，5-代销2.0
     */
    private Integer businessForm;
    /**
     * 商品状态，0-未上架，1-未上架，2-已上架，4-预上架
     */
    private Integer status;

    /**
     * 商品负责人信息
     */
    private ChangeGoodsPrincipalPO changeGoodsPrincipal;

}