/**
 * @(#)buildAndSendEmail.java, 2023/2/7.
 * <p/>
 * Copyright 2023 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;

/**
 * @Author zcwang
 * @Date 2023/2/7
 */
public interface BuildAndSendEmail {

    /**
     * 创建工单，创建人=变更负责人，组装提交数据，并发送邮件
     * @param changeRecord
     * @param changeExecRecords
     * @param changeType
     * @param changeCommander
     * @param changeFlowCreateReq
     */
    void buildAndSendEmailCreate(ChangeRecord changeRecord, List<ChangeExecRecord> changeExecRecords, StringBuilder changeType, String changeCommander, ChangeFlowCreateReq changeFlowCreateReq);

    /**
     * 提交工单，变更确认节点，组装提交数据，并发送邮件
     * @param changeRecord
     * @param changeExecRecords
     */
    void buildAndSendEmailSubmit(ChangeRecord changeRecord, List<ChangeExecRecord> changeExecRecords);
}