package com.netease.mail.yanxuan.change.biz.service.impl.change;

import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeExecConfigService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecConfig;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeExecConfigMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class ChangeExecConfigServiceImpl implements ChangeExecConfigService {

    @Autowired
    private ChangeExecConfigMapper mapper;

    @Override
    public List<ChangeExecConfig> queryChangeExecConfig(Long changeTemplateId) {
        return mapper.queryChangeExecConfig(changeTemplateId);
    }

    @Override
    @Transactional
    public Boolean addChangeExecConfig(List<ChangeExecConfig> changeExecConfigs) {
        if (changeExecConfigs == null || changeExecConfigs.size() >=21){
            throw ExceptionFactory.createBiz(ResponseCode.EXEC_CONFIG_LENGTH);
        }
        //循环添加
        for (ChangeExecConfig changeExecConfig : changeExecConfigs){
            //行动项,变更风险描述,  变更验证措施, 需要判断字段长度   参数验证 暂不验证
            mapper.insertSelective(changeExecConfig);
        }
        return true;
    }

    @Override
    public Boolean updateChangeExecConfig(ChangeExecConfig changeExecConfig) {
        //行动项,变更风险描述,  变更验证措施, 需要判断字段长度   参数验证 暂不验证
        mapper.updateByPrimaryKeySelective(changeExecConfig);
        return true;
    }

    @Override
    public Boolean deleteChangeExecConfig(Long id) {
        mapper.deleteById(id);
        return true;
    }
}
