/**
 * @(#)TodoService.java, 2022/11/29.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.meta.exception.ExceptionFactory;
import com.netease.mail.yanxuan.change.common.bean.CommonConstants;
import com.netease.mail.yanxuan.change.common.bean.ResponseCode;
import com.netease.mail.yanxuan.change.common.bean.ResponseCodeEnum;
import com.netease.mail.yanxuan.change.common.enums.OperateTypeEnum;
import com.netease.mail.yanxuan.change.common.enums.TodoTaskTypeEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.integration.todo.TaskCreateDTO;
import com.netease.mail.yanxuan.change.integration.todo.TaskCreateParamVO;
import com.netease.mail.yanxuan.change.integration.todo.TaskProcessParamVO;
import com.netease.mail.yanxuan.change.integration.todo.TodoRpcService;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/11/29
 */
@Component
@Slf4j
public class TodoService {

    @Autowired
    private TodoRpcService todoRpcService;

    /**
     * 创建代办
     * @param entity
     */
    public TaskCreateDTO createTodoTask(ChangeRecord entity) {
        String changeCommander = entity.getChangeCommander();
        TaskCreateDTO taskCreateDTO = new TaskCreateDTO();
        if (StringUtils.isNotEmpty(changeCommander)) {
            String flowId = String.valueOf(entity.getFlowId());
            Map<String, Object> businessContent = new HashMap<>();
            businessContent.put("nodeTitle", entity.getChangeContent());
            businessContent.put("taskFlowId", flowId);
            businessContent.put("newFlow", flowId);
            TaskCreateParamVO taskCreateParamVO = new TaskCreateParamVO();
            taskCreateParamVO.setBusinessKey(flowId);
            taskCreateParamVO.setContent(JSON.toJSONString(businessContent));
            taskCreateParamVO.setProduct(CommonConstants.FLOWX_PRODUCT);
            taskCreateParamVO.setTaskCreator(changeCommander);
            taskCreateParamVO.setTaskHandler(changeCommander);
            taskCreateParamVO.setTaskHandlerName(changeCommander);
            taskCreateParamVO.setTaskTitle("测试");
            taskCreateParamVO.setTaskTypeKey(TodoTaskTypeEnum.QC_CHANGE.getValue());
            AjaxResponse<TaskCreateDTO> taskCreateResponse = todoRpcService.create(taskCreateParamVO);
            if (ResponseCodeEnum.SUCCESS.getCode() == taskCreateResponse.getCode()) {
                taskCreateDTO = taskCreateResponse.getData();
                log.info("[createTodoTask] taskCreateDTO={}", JSON.toJSONString(taskCreateDTO));

            } else {
                log.error("[createTodoTask] create todo failed, param={}, errMsg={}", JSON.toJSONString(taskCreateParamVO),
                        JSON.toJSONString(taskCreateResponse));
                throw ExceptionFactory.createBiz(ResponseCode.CREATE_TODO_ERROR, "查询工单详情错误");
            }

        }
        return taskCreateDTO;
    }

    /**
     * 完成代办
     * @param entity
     */
    public void finishTodoTask(ChangeRecord entity) {
        String changeCommander = entity.getChangeCommander();
        String flowId = String.valueOf(entity.getFlowId());
        log.info("[finishSupplierTodoTask] taskFlowId={}, supplierId={}", flowId, changeCommander);
        if (StringUtils.isNotEmpty(changeCommander)) {
            TaskProcessParamVO taskProcessParamVO = new TaskProcessParamVO();
            taskProcessParamVO.setBusinessKey(flowId);
            taskProcessParamVO.setOperateType(OperateTypeEnum.FINISH.getType());
            taskProcessParamVO.setOperator(changeCommander);
            taskProcessParamVO.setOperatorName(changeCommander);
            taskProcessParamVO.setProduct(CommonConstants.FLOWX_PRODUCT);
            taskProcessParamVO.setTaskId(entity.getTodoId());
            todoRpcService.progress(taskProcessParamVO);
        }
    }
}