/**
 * @(#)ChangeFlowExecService.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service;

import java.util.List;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowExecVO;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
public interface ChangeFlowExecService {

    /**
     * 查询行动项
     * @param changeRecordId
     * @return
     */
    List<ChangeFlowExecVO> getChangeFlowExecRecord(Long changeRecordId);

    /**
     * 查询行动项实体列表
     * @param changeRecordId
     * @return
     */
    List<ChangeExecRecord> getChangeExecRecordList(Long changeRecordId);

    /**
     * 批量保存变更行动执行记录
     * @param changeExecRecordList
     */
    void batchSaveRecord(List<ChangeExecRecord> changeExecRecordList);

    Boolean update(ChangeExecRecord exec);

    Integer deleteByChangeRecordId(Long id);

    void saveRecord(ChangeExecRecord exec);

    /**
     * 查询包含执行人的工单
     * @param changeExecUser
     * @return
     */
    List<Long> queryByExecUser(String changeExecUser);

    /**
     * 根据变更行动工单记录ID查询行动项列表
     * @param subFlowRecordId 变更行动工单记录ID
     * @return 行动项列表
     */
    List<ChangeExecRecord> getBySubFlowRecordId(Long subFlowRecordId);

    /**
     * 批量根据变更行动工单记录ID列表查询行动项列表
     * @param subFlowRecordIds 变更行动工单记录ID列表
     * @return 行动项列表
     */
    List<ChangeExecRecord> getBySubFlowRecordIds(List<Long> subFlowRecordIds);

    /**
     * 根据变更行动人和部门查询变更行动工单记录ID列表（合并查询）
     * @param changeExecUser 变更行动人（邮箱），可为空
     * @param changeExecDepartment 变更行动部门，可为空
     * @return 变更行动工单记录ID列表
     */
    List<Long> querySubFlowRecordIdsByExecCondition(String changeExecUser, String changeExecDepartment);
}