package com.netease.mail.yanxuan.change.integration.email.enums;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public enum ProductCodeEnum {

    /**
     * 异常管理中心
     */
    EHC("ehc", "异常管理中心"),
    /**
     * 品控
     */
    QC("qc", "品控"),

    /**
     * 承运商平台
     */
    CARRIER("carrier", "承运商"),

    /**
     * 仓配
     */
    ARK("ark", "仓配"),

    /**
     * 商品中心
     */
    ITEM_CENTER("ic", "商品中心"),

    /**
     * 同舟系统
     */
    SUPPLIER_API("supplier_api", "同舟"),

    /**
     * 大黄蜂
     */
    HORNET("hornet", "大黄蜂"),

    /**
     * 供应商协同
     */
    YXSUPPLIER("yxsupplier", "供应商协同"),

    /**
     * 采购
     */
    PMC("pmc", "采购"),

    /**
     * 逆向管理系统
     */
    SUPPLIER_RL("yanxuan-supplier-rl", "逆向管理系统"),

    /**
     * 销退系统
     */
    SALES_RETURN("yanxuan-sales-return", "销退系统");



    public static ProductCodeEnum getByValue(String code) {
        for (ProductCodeEnum c: ProductCodeEnum.values()) {
            if (c.getCode().equals(code)) {
                return c;
            }
        }
        return null;
    }

    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
