package com.netease.mail.yanxuan.change.biz.service.impl.change;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.dal.entity.ChangeConfig;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeConfigMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@Service
public class ChangeConfigServiceImpl implements ChangeConfigService {

    @Autowired
    public ChangeConfigMapper mapper;

    @Override
    public ChangeConfig queryChangeConfig(Long id) {
        return mapper.queryById(id);
    }

    @Override
    public ChangeConfig queryChangeType(Long parentChangeClassId, Long sonChangeClassId) {
        if (parentChangeClassId == null || sonChangeClassId == null){
            return null;
        }
        return mapper.queryChangeType(parentChangeClassId, sonChangeClassId);
    }

    @Override
    public Boolean deleteChangeConfig(Long id) {
        mapper.deleteById(id);
        return true;
    }

    @Override
    public ChangeConfig addChangeConfig(ChangeConfig changeConfig) {
        mapper.add(changeConfig);
        return changeConfig;
    }

    @Override
    public Boolean updateChangeConfig(ChangeConfig changeConfig) {
        changeConfig.setUpdateTime(System.currentTimeMillis());
        mapper.updateByPrimaryKeySelective(changeConfig);
        return true;
    }

    @Override
    public ChangeConfig getSonChange(Long sonChangeId) {
        return mapper.selectBySonConfig(sonChangeId);
    }
}
