/**
 * @(#)ChangeSubFlowRecordMapper.java, 2024/01/01.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowRecord;

/**
 * @Author system
 * @Date 2024/01/01
 */
@Mapper
public interface ChangeSubFlowRecordMapper extends tk.mybatis.mapper.common.Mapper<ChangeSubFlowRecord> {

    /**
     * 根据主单记录ID查询变更行动工单列表
     * @param changeRecordId 主单记录ID
     * @return 变更行动工单列表
     */
    @Select("SELECT * FROM TB_YX_QC_CHANGE_SUB_FLOW_RECORD WHERE change_record_id = #{changeRecordId}")
    List<ChangeSubFlowRecord> selectByChangeRecordId(@Param("changeRecordId") Long changeRecordId);

    /**
     * 根据变更行动工单ID查询变更行动工单记录
     * @param subFlowId 变更行动工单ID（即topo）
     * @return 变更行动工单记录
     */
    @Select("SELECT * FROM TB_YX_QC_CHANGE_SUB_FLOW_RECORD WHERE sub_flow_id = #{subFlowId} LIMIT 1")
    ChangeSubFlowRecord selectBySubFlowId(@Param("subFlowId") String subFlowId);

    /**
     * 批量根据主单记录ID列表查询变更行动工单列表
     * @param changeRecordIds 主单记录ID列表
     * @return 变更行动工单列表
     */
    @Select("<script>" +
            "SELECT * FROM TB_YX_QC_CHANGE_SUB_FLOW_RECORD " +
            "WHERE change_record_id IN " +
            "<foreach collection='changeRecordIds' item='id' open='(' separator=',' close=')'>" +
            "#{id}" +
            "</foreach>" +
            "</script>")
    List<ChangeSubFlowRecord> selectByChangeRecordIds(@Param("changeRecordIds") List<Long> changeRecordIds);

    /**
     * 批量根据ID列表查询变更行动工单列表
     * @param ids ID列表
     * @return 变更行动工单列表
     */
    @Select("<script>" +
            "SELECT * FROM TB_YX_QC_CHANGE_SUB_FLOW_RECORD " +
            "WHERE id IN " +
            "<foreach collection='ids' item='id' open='(' separator=',' close=')'>" +
            "#{id}" +
            "</foreach>" +
            "</script>")
    List<ChangeSubFlowRecord> selectByIds(@Param("ids") List<Long> ids);

    /**
     * 根据条件查询变更行动工单列表
     * @param queryReq 查询条件
     * @return 变更行动工单列表
     */
    List<ChangeSubFlowRecord> selectByCondition(com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowListQueryReq queryReq);

}

