/**
 * @(#)ChangeRecordMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowListQueryReq;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeRecordMapper extends tk.mybatis.mapper.common.Mapper<ChangeRecord> {

    @Select("select * from TB_YX_QC_CHANGE_RECORD where `flow_id` = #{flowId} limit 1")
    ChangeRecord selectByFlowId(@Param("flowId") Long flowId);

    /**
     * 批量根据ID列表查询变更记录
     * @param ids ID列表
     * @return 变更记录列表
     */
    @Select("<script>" +
            "SELECT * FROM TB_YX_QC_CHANGE_RECORD WHERE id IN " +
            "<foreach collection='ids' item='id' open='(' separator=',' close=')'>" +
            "#{id}" +
            "</foreach>" +
            "</script>")
    List<ChangeRecord> selectByIds(@Param("ids") List<Long> ids);

    List<ChangeRecord> selectByCondition(ChangeFlowListQueryReq changeFlowListQueryReq);

    List<ChangeRecord> selectByConditionAndLimit(ChangeFlowListQueryReq changeFlowListQueryReq);

    @Select("select * from TB_YX_QC_CHANGE_RECORD where id > #{entityId} and auto_submit_email = #{sendEmail} and `flow_node` in (#{nodeId1}, #{nodeId2}) and change_confirm_result_time <= #{currentTime} limit 200")
    List<ChangeRecord> getByStatusAndTime(@Param("entityId") Long entityId, @Param("sendEmail") Integer sendEmail, @Param("nodeId1") String nodeId1,
                                          @Param("nodeId2") String nodeId2, @Param("currentTime") long currentTime);
}
