package com.netease.mail.yanxuan.change.web.aop;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.biz.meta.exception.ServiceException;
import com.netease.mail.yanxuan.change.common.util.RequestUtil;
import com.netease.mail.yanxuan.change.common.util.ResponseUtil;

import lombok.extern.slf4j.Slf4j;

@ControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

    @ExceptionHandler(value = Exception.class)
    public void handle(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        String pathInfo = RequestUtil.getRequestPath(request);

        if (ex instanceof ServiceException) {
            log.error("biz error on handle  request: {},{}", pathInfo, ((ServiceException) ex).getMsg());
        } else if (ex instanceof TypeMismatchException) {
            ex = new IllegalArgumentException("参数" + ((TypeMismatchException) ex).getRequiredType() + "类型不匹配");
            log.error("handleException pathInfo:{},param:{}", pathInfo,JSON.toJSONString(request.getParameterMap()), ex);
        } else if (ex instanceof MissingServletRequestParameterException) {
            ex = new IllegalArgumentException(
                "缺少参数" + ((MissingServletRequestParameterException) ex).getParameterName());
            log.error("handleException pathInfo:{},param:{}", pathInfo,JSON.toJSONString(request.getParameterMap()), ex);
        } else {
            log.error("error on handle request: {}", pathInfo, ex);
        }

        AjaxResult result = new AjaxResult();
        result.setCode(monitorException(ex));

        if (ex instanceof IllegalArgumentException) {
            result.setMsg(ex.getMessage());
        } else if (ex instanceof ServiceException) {
            result.setMsg(((ServiceException) ex).getMsg());
        } else if (ex instanceof MethodArgumentNotValidException) {
            // controller参数校验错误
            StringBuilder builder = new StringBuilder();
            for (FieldError error: ((MethodArgumentNotValidException) ex).getBindingResult().getFieldErrors()) {
                builder.append(error.getDefaultMessage()).append(".");
            }
            result.setMsg(builder.toString());
        } else {
            int index = ex.getMessage().indexOf(":");
            if (index != -1) {
                result.setMsg(ex.getMessage().substring(index + 1));
            } else {
                result.setMsg(ex.getMessage());
            }
        }

        String text = JSON.toJSONString(result);
        String callback = request.getParameter("callback");
        if (!StringUtils.isEmpty(callback)) {
            text = callback + "(" + text + ")";
        }
        ResponseUtil.writeJson(response, text);
    }

    private int monitorException(Exception ex) {
        if (ex instanceof IOException) {
            return HttpStatus.BAD_REQUEST.value();
        } else if (ex instanceof IllegalArgumentException) {
            return HttpStatus.BAD_REQUEST.value();
        } else if (ex instanceof ServiceException) {
            return ((ServiceException) ex).getCode().getCode();
        } else {
            return HttpStatus.INTERNAL_SERVER_ERROR.value();
        }
    }
}
