ALTER TABLE `TB_YX_QC_CHANGE_EXEC_RECORD` ADD COLUMN `sub_flow_id` varchar(100) NOT NULL DEFAULT '' COMMENT '子流程工单ID' AFTER `change_exec_finish_desc`,
ADD COLUMN `sub_flow_record_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '变更行动工单记录ID（关联到变更行动工单中间表，新数据使用）' AFTER `sub_flow_id`,
ADD INDEX `idx_sub_flow_record_id` (`sub_flow_record_id`) USING BTREE COMMENT '变更行动工单记录ID索引',
ADD INDEX `idx_change_exec_user_email` (`change_exec_user_email`) USING BTREE COMMENT '变更行动人邮箱索引';

ALTER TABLE `TB_YX_QC_CHANGE_RECORD` ADD COLUMN `approver` varchar(500) NOT NULL DEFAULT '' COMMENT '变更审批人（JSON格式，存储当前节点的审批人列表，用于查询过滤）',
ADD COLUMN `batch_description` VARCHAR(512) NOT NULL DEFAULT '' COMMENT '批次说明' AFTER `change_profit_amount`;

CREATE TABLE `TB_YX_QC_CHANGE_SUB_FLOW_RECORD`
(
    `id`                     bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `change_record_id`       bigint(20) NOT NULL DEFAULT '0' COMMENT '主单记录ID（变更记录ID）',
    `sub_flow_id`            varchar(100) NOT NULL DEFAULT '' COMMENT '变更行动工单ID（即topo）',
    `sub_flow_node`          varchar(20)  NOT NULL DEFAULT '' COMMENT '变更行动工单当前节点',
    `status`                 int(2) NOT NULL DEFAULT '0' COMMENT '变更行动工单状态，1待确认行动方案,2待审批行动方案,3待审批变更方案,4待提交执行结果,5已完结,6已取消',
    `approver`               varchar(500) NOT NULL DEFAULT '' COMMENT '变更行动工单审批人（JSON格式，存储审批人列表，第一次新建时就是行动人）',
    `change_exec_user_email` varchar(70)  NOT NULL DEFAULT '' COMMENT '变更行动人邮箱（用于查询和展示，新建时从行动项获取）',
    `change_exec_department` varchar(50)  NOT NULL DEFAULT '' COMMENT '变更行动部门（用于查询和展示，新建时从行动项获取）',
    `change_commander`       varchar(70)  NOT NULL DEFAULT '' COMMENT '变更负责人（用于查询和展示，新建时从主单获取）',
    `reject_reason`          VARCHAR(500) NOT NULL DEFAULT '' COMMENT '拒绝原因',
    `change_result`          INT(2) NOT NULL DEFAULT 0 COMMENT '变更结论（0-未设置/1-完成所有/2-部分完成/3-取消/4-延期）',
    `remark`                 VARCHAR(500) NOT NULL DEFAULT '' COMMENT '备注',
    `cancel_reason`          VARCHAR(500) NOT NULL DEFAULT '' COMMENT '取消原因',
    `change_confirm_result_time` bigint(20) NOT NULL DEFAULT '0' COMMENT '变更确认结果时间（从主单创建时继承，延期时可覆盖）',
    `create_time`            bigint(20) NOT NULL DEFAULT '0' COMMENT '创建时间',
    `update_time`            bigint(20) NOT NULL DEFAULT '0' COMMENT '更新时间',
    PRIMARY KEY (`id`),
    KEY                      `idx_change_record_id` (`change_record_id`) USING BTREE COMMENT '主单记录ID索引',
    KEY                      `idx_sub_flow_id` (`sub_flow_id`) USING BTREE COMMENT '变更行动工单ID索引',
    KEY                      `idx_status` (`status`) USING BTREE COMMENT '状态索引',
    KEY                      `idx_change_exec_user_email` (`change_exec_user_email`) USING BTREE COMMENT '变更行动人邮箱索引',
    KEY                      `idx_change_commander` (`change_commander`) USING BTREE COMMENT '变更负责人索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='变更行动工单记录表';

CREATE TABLE `TB_YX_QC_CHANGE_SUB_FLOW_FILE`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
    `sub_flow_record_id` bigint(20) NOT NULL COMMENT '子单记录ID',
    `file_name`          varchar(255) NOT NULL DEFAULT '' COMMENT '文件名',
    `file_url`           varchar(500) NOT NULL DEFAULT '' COMMENT '文件URL',
    `file_type`          int(11) NOT NULL DEFAULT '0' COMMENT '文件类型（参考 FileTypeEnum）',
    `create_time`        bigint(20) NOT NULL COMMENT '创建时间',
    `update_time`        bigint(20) NOT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`),
    KEY                  `idx_sub_flow_record_id` (`sub_flow_record_id`),
    KEY                  `idx_file_type` (`file_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='子单文件表';