/**
 * @(#)ChangeFlowExcelDTO.java, 2022/11/25.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.excel;

import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/25
 */
@Data
public class ChangeFlowExcelDTO {
    /**
     * 变更id
     */
    @Excel(name = "变更id")
    private Long flowId;

    /**
     * 变更发起时间
     */
    @Excel(name = "变更发起时间")
    private String createTime;

    /**
     * 变更发起人
     */
    @Excel(name = "变更发起人")
    private String changeCreator;

    /**
     * 变更主体
     * @see ChangeSubjectEnum
     */
    @Excel(name = "变更主体")
    private String changeSubject;

    /**
     * 变更类型，一级类型>二级类型
     */
    @Excel(name = "变更类型")
    private String changeType;

    /**
     * 变更等级
     */
    @Excel(name = "变更等级")
    private String changeLevel;

    /**
     * 变更负责部门名
     */
    @Excel(name = "变更负责部门名")
    private String changeDepartment;

    /**
     * 变更负责人
     */
    @Excel(name = "变更负责人")
    private String changeCommander;
    /**
     * 变更供应商：供应商ID+供应商名称
     */
    @Excel(name = "变更供应商")
    private String supplier;

    /**
     * 变更原因
     */
    @Excel(name = "变更原因")
    private String changeReason;

    /**
     * 变更内容
     */
    @Excel(name = "变更内容")
    private String changeContent;

    /**
     * 变更潜在风险描述
     */
    @Excel(name = "变更潜在风险描述")
    private String changeRiskDesc;

    /**
     * 变更收益类型
     */
    @Excel(name = "变更收益类型")
    private String changeProfit;

    /**
     * 变更收益说明
     */
    @Excel(name = "变更收益说明")
    private String changeProfitDesc;

    /**
     * 变更商品,商品名称
     */
    @Excel(name = "变更商品")
    private String changeItem;

    /**
     * SPUID
     */
    @Excel(name = "SPUID")
    private Long SPUId;

    /**
     * 品控类目
     */
    @Excel(name = "品控类目")
    private String qcCategory;

    /**
     * 物理类目
     */
    @Excel(name = "物理类目")
    private String phyCategory;

    /**
     * 商品立项类型，0-正常立项商品，2-特殊免立项商品 3-组合装
     */
    @Excel(name = "商品立项类型")
    private String itemSetupType;

    /**
     * 经营形式，0-自营，3-严选贴牌代销，4-他方品牌代销，5-代销2.0
     */
    @Excel(name = "经营形式")
    private String businessForm;
    /**
     * 商品状态，0-未上架，1-未上架，2-已上架，4-预上架
     */
    @Excel(name = "商品状态")
    private String status;

    /**
     * 商品负责人
     */
    @Excel(name = "商品负责人")
    private String functionary;

    /**
     * 采购负责人
     */
    @Excel(name = "采购负责人")
    private String purchase;

    /**
     * SQE负责人
     */
    @Excel(name = "SQE负责人")
    private String goodsSqe;
    /**
     * 计划负责人
     */
    @Excel(name = "计划负责人")
    private String goodsProject;

    /**
     * 变更行动部门
     */
    @Excel(name = "变更行动部门")
    private String execDepartment;

    /**
     * 变更行动人
     */
    @Excel(name = "变更行动人")
    private String changeExecUser;

    /**
     * 行动项变更风险描述
     */
    @Excel(name = "行动项变更风险描述")
    private String changeExecRiskDesc;

    /**
     * 行动项
     */
    @Excel(name = "行动项")
    private String changeExecProject;

    /**
     * 变更验证措施
     */
    @Excel(name = "变更验证措施")
    private String changeChecking;
    /**
     * 行动完成时间
     */
    @Excel(name = "行动完成时间")
    private String changeExecFinishTime;

    /**
     * 行动完成情况
     */
    @Excel(name = "行动完成情况")
    private String changeExecFinishDesc;

    /**
     * 变更结论
     */
    @Excel(name = "变更结论")
    private String changeResult;

    /**
     * 变更完结时间
     */
    @Excel(name = "变更完结时间")
    private String changeEndTime;
}