package com.netease.mail.yanxuan.change.dal.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * redis文件配置
 */
@Slf4j
@Configuration
public class RedisSentinelConfig {

    @Autowired
    private DrmRedisConfig drmRedisConfig;

    @Bean
    public RedisConnectionFactory lettuceConnectionFactory() {
        Set<String> nodes = Arrays.stream(drmRedisConfig.getNodes().split(",")).collect(Collectors.toSet());
        RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration(drmRedisConfig.getMaster(), nodes);
        redisSentinelConfiguration.setPassword(RedisPassword.of(drmRedisConfig.getPassword()));
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(drmRedisConfig.getMaxIdle());
        genericObjectPoolConfig.setMinIdle(drmRedisConfig.getMinIdle());
        genericObjectPoolConfig.setMaxTotal(drmRedisConfig.getMaxTotal());
        genericObjectPoolConfig.setMaxWaitMillis(drmRedisConfig.getMaxWaitMillis());
        LettucePoolingClientConfiguration lettuceClientConfiguration = LettucePoolingClientConfiguration.builder().poolConfig(genericObjectPoolConfig).build();
        return new LettuceConnectionFactory(redisSentinelConfiguration, lettuceClientConfiguration);
    }
}
