package com.netease.mail.yanxuan.change.biz.service.impl;

import com.netease.mail.yanxuan.change.biz.service.ISupplierItemService;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierGoodsInfoReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierGoodsInfoRsp;
import com.netease.mail.yanxuan.change.integration.item.ItemRpcService;
import com.netease.mail.yanxuan.change.integration.item.meta.SpuTO;
import com.netease.mail.yanxuan.change.integration.item.param.BatchQuerySpuInfoParam;
import com.netease.mail.yanxuan.change.integration.todo.PageVO;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemPageVO;
import com.netease.mail.yanxuan.change.integration.todo.SupplierItemVO;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
public class SupplierItemServiceImpl implements ISupplierItemService {

    @Autowired
    private FlowRpcSupplierSendService flowRpcSupplierSendService;

    @Autowired
    private ItemRpcService itemRpcService;

    @Override
    public SupplierItemPageVO supplierGoodsInfoBySupplier(SupplierGoodsInfoReq supplierGoodsInfoReq, String itemId, String itemName, Integer page, Integer pageSize) {
        AjaxResponse<List<SupplierGoodsInfoRsp>> listAjaxResponse = flowRpcSupplierSendService.supplierGoodsInfoBySupplier(supplierGoodsInfoReq);
        List<SupplierGoodsInfoRsp> data = listAjaxResponse.getData();
        List<SpuTO> spuTOList = new ArrayList<>();
        if (data != null) {
            Set<Long> fullItemIds = data.stream().map(SupplierGoodsInfoRsp::getItemId).collect(Collectors.toSet());
            while (fullItemIds.size() > 200) {
                List<Long> itemIds = new ArrayList<>(fullItemIds).subList(0, 200);
                AjaxResult<List<SpuTO>> listAjaxResult = itemRpcService.batchQuerySpuInfo(BatchQuerySpuInfoParam.builder().ids(itemIds).build());
                List<SpuTO> pageSpuTo = listAjaxResult.getData();
                if (!CollectionUtils.isEmpty(pageSpuTo)) {
                    spuTOList.addAll(pageSpuTo);
                }
                fullItemIds.removeAll(itemIds);
            }
            List<Long> itemIds = new ArrayList<>(fullItemIds);
            AjaxResult<List<SpuTO>> listAjaxResult = itemRpcService.batchQuerySpuInfo(BatchQuerySpuInfoParam.builder().ids(itemIds).build());
            List<SpuTO> pageSpuTo = listAjaxResult.getData();
            if (!CollectionUtils.isEmpty(pageSpuTo)) {
                spuTOList.addAll(pageSpuTo);
            }
        }
        if (StringUtils.isNotBlank(itemId)) {
            spuTOList = spuTOList.stream().filter(i -> Long.valueOf(itemId).equals(i.getId())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(itemName)) {
            spuTOList = spuTOList.stream().filter(i -> i.getName().contains(itemName)).collect(Collectors.toList());
        }
        PageVO pageVO = buildPageVo(spuTOList.size(), page, pageSize);
        Integer endIndex = page * pageSize;
        if (page * pageSize > spuTOList.size()) {
            endIndex = spuTOList.size();
        }
        List<SpuTO> pageItem = spuTOList.subList((page - 1) * pageSize, endIndex);
        List<SupplierItemVO> supplierItemVOList = pageItem.stream().map(i -> {
            SupplierItemVO supplierItemVO = new SupplierItemVO();
            supplierItemVO.setItemId(i.getId());
            supplierItemVO.setItemName(i.getName());
            return supplierItemVO;
        }).collect(Collectors.toList());
        return SupplierItemPageVO.builder().pageVo(pageVO).supplierItemVOList(supplierItemVOList).build();
    }

    private PageVO buildPageVo(int size, Integer page, Integer pageSize) {
        int totalPage = size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
        return PageVO.builder().page(page).pageSize(pageSize).totalCount(size).totalPage(totalPage).build();
    }
}
