/**
 * @(#)TaskProcessParamVO.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.todo;

import com.netease.mail.yanxuan.change.common.enums.OperateTypeEnum;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Data
public class TaskProcessParamVO {

    /**
     * 业务key，非必填
     */
    private String businessKey;
    /**
     * 系统自定义抄送人，非必填
     */
    private String cc;
    /**
     * 任务详情，仅保存操作时必填
     */
    private String content;
    /**
     * 延期时间，仅延期操作时必填
     */
    private Integer delayTime;
    /**
     * 任务的上次更新时间，用于版本控制，非必填
     */
    private Integer lastUpdateTime;
    /**
     * 操作:1 完成 2 取消 3 转交 4 延期 7 保存，必填
     * @see OperateTypeEnum
     */
    private Integer operateType;
    /**
     * 操作人邮箱，必填
     */
    private String operator;
    /**
     * 操作人名称，必填
     */
    private String operatorName;
    /**
     * 系统产品号，必填
     */
    private String product;
    /**
     * 系统自定义收件人,非必填
     */
    private String recipient;
    /**
     * 备注信息，非必填
     */
    private String remark;
    /**
     * 任务ID，必填
     */
    private Integer taskId;
    /**
     * 被转交人邮箱，仅转交操作时必填
     */
    private String transfer;
    /**
     * 被转交人姓名，仅转交操作时必填
     */
    private String transferName;
}